package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;

import odata.msgraph.client.beta.enums.DeviceManagementConfigurationDeviceMode;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationPlatforms;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationTechnologies;


/**
 * <i>“Applicability for an Exchange Online Setting”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationExchangeOnlineSettingApplicability extends DeviceManagementConfigurationSettingApplicability implements ODataType {

    protected DeviceManagementConfigurationExchangeOnlineSettingApplicability() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationExchangeOnlineSettingApplicability";
    }

    public DeviceManagementConfigurationExchangeOnlineSettingApplicability withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationExchangeOnlineSettingApplicability _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationExchangeOnlineSettingApplicability() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private DeviceManagementConfigurationDeviceMode deviceMode;
        private DeviceManagementConfigurationPlatforms platform;
        private DeviceManagementConfigurationTechnologies technologies;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceMode(DeviceManagementConfigurationDeviceMode deviceMode) {
            this.deviceMode = deviceMode;
            this.changedFields = changedFields.add("deviceMode");
            return this;
        }

        public Builder platform(DeviceManagementConfigurationPlatforms platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        public Builder technologies(DeviceManagementConfigurationTechnologies technologies) {
            this.technologies = technologies;
            this.changedFields = changedFields.add("technologies");
            return this;
        }

        public DeviceManagementConfigurationExchangeOnlineSettingApplicability build() {
            DeviceManagementConfigurationExchangeOnlineSettingApplicability _x = new DeviceManagementConfigurationExchangeOnlineSettingApplicability();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationExchangeOnlineSettingApplicability";
            _x.description = description;
            _x.deviceMode = deviceMode;
            _x.platform = platform;
            _x.technologies = technologies;
            return _x;
        }
    }

    private DeviceManagementConfigurationExchangeOnlineSettingApplicability _copy() {
        DeviceManagementConfigurationExchangeOnlineSettingApplicability _x = new DeviceManagementConfigurationExchangeOnlineSettingApplicability();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.deviceMode = deviceMode;
        _x.platform = platform;
        _x.technologies = technologies;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationExchangeOnlineSettingApplicability[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceMode=");
        b.append(this.deviceMode);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("technologies=");
        b.append(this.technologies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
