package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "dependentOn", 
    "parentSettingId"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationDependentOn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dependentOn")
    protected String dependentOn;

    @JsonProperty("parentSettingId")
    protected String parentSettingId;

    protected DeviceManagementConfigurationDependentOn() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationDependentOn";
    }

    /**
     * <i>“Identifier of parent setting/ parent setting option dependent on”</i>
     * 
     * @return property dependentOn
     */
    @Property(name="dependentOn")
    @JsonIgnore
    public Optional<String> getDependentOn() {
        return Optional.ofNullable(dependentOn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dependentOn}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Identifier of parent setting/ parent setting option dependent on”</i>
     * 
     * @param dependentOn
     *            new value of {@code dependentOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dependentOn} field changed
     */
    public DeviceManagementConfigurationDependentOn withDependentOn(String dependentOn) {
        DeviceManagementConfigurationDependentOn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationDependentOn");
        _x.dependentOn = dependentOn;
        return _x;
    }

    /**
     * <i>“Identifier of parent setting/ parent setting id dependent on”</i>
     * 
     * @return property parentSettingId
     */
    @Property(name="parentSettingId")
    @JsonIgnore
    public Optional<String> getParentSettingId() {
        return Optional.ofNullable(parentSettingId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code parentSettingId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Identifier of parent setting/ parent setting id dependent on”</i>
     * 
     * @param parentSettingId
     *            new value of {@code parentSettingId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code parentSettingId} field changed
     */
    public DeviceManagementConfigurationDependentOn withParentSettingId(String parentSettingId) {
        DeviceManagementConfigurationDependentOn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationDependentOn");
        _x.parentSettingId = parentSettingId;
        return _x;
    }

    public DeviceManagementConfigurationDependentOn withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationDependentOn _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String dependentOn;
        private String parentSettingId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Identifier of parent setting/ parent setting option dependent on”</i>
         * 
         * @param dependentOn
         *            value of {@code dependentOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependentOn(String dependentOn) {
            this.dependentOn = dependentOn;
            this.changedFields = changedFields.add("dependentOn");
            return this;
        }

        /**
         * <i>“Identifier of parent setting/ parent setting id dependent on”</i>
         * 
         * @param parentSettingId
         *            value of {@code parentSettingId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder parentSettingId(String parentSettingId) {
            this.parentSettingId = parentSettingId;
            this.changedFields = changedFields.add("parentSettingId");
            return this;
        }

        public DeviceManagementConfigurationDependentOn build() {
            DeviceManagementConfigurationDependentOn _x = new DeviceManagementConfigurationDependentOn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationDependentOn";
            _x.dependentOn = dependentOn;
            _x.parentSettingId = parentSettingId;
            return _x;
        }
    }

    private DeviceManagementConfigurationDependentOn _copy() {
        DeviceManagementConfigurationDependentOn _x = new DeviceManagementConfigurationDependentOn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dependentOn = dependentOn;
        _x.parentSettingId = parentSettingId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationDependentOn[");
        b.append("dependentOn=");
        b.append(this.dependentOn);
        b.append(", ");
        b.append("parentSettingId=");
        b.append(this.parentSettingId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
