package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Choice Setting Value Constant Default Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "children", 
    "settingDefinitionOptionId"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate extends DeviceManagementConfigurationChoiceSettingValueDefaultTemplate implements ODataType {

    @JsonProperty("children")
    protected List<DeviceManagementConfigurationSettingInstanceTemplate> children;

    @JsonProperty("children@nextLink")
    protected String childrenNextLink;

    @JsonProperty("settingDefinitionOptionId")
    protected String settingDefinitionOptionId;

    protected DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate";
    }

    /**
     * <i>“Option Children”</i>
     * 
     * @return property children
     */
    @Property(name="children")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate> getChildren() {
        return new CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate>(contextPath, DeviceManagementConfigurationSettingInstanceTemplate.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Option Children”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property children
     */
    @Property(name="children")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate> getChildren(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate>(contextPath, DeviceManagementConfigurationSettingInstanceTemplate.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Default Constant Value”</i>
     * 
     * @return property settingDefinitionOptionId
     */
    @Property(name="settingDefinitionOptionId")
    @JsonIgnore
    public Optional<String> getSettingDefinitionOptionId() {
        return Optional.ofNullable(settingDefinitionOptionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingDefinitionOptionId} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Default Constant Value”</i>
     * 
     * @param settingDefinitionOptionId
     *            new value of {@code settingDefinitionOptionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingDefinitionOptionId} field changed
     */
    public DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate withSettingDefinitionOptionId(String settingDefinitionOptionId) {
        DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate");
        _x.settingDefinitionOptionId = settingDefinitionOptionId;
        return _x;
    }

    public DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private List<DeviceManagementConfigurationSettingInstanceTemplate> children;
        private String childrenNextLink;
        private String settingDefinitionOptionId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Option Children”</i>
         * 
         * @param children
         *            value of {@code children} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder children(List<DeviceManagementConfigurationSettingInstanceTemplate> children) {
            this.children = children;
            this.changedFields = changedFields.add("children");
            return this;
        }

        /**
         * <i>“Option Children”</i>
         * 
         * @param children
         *            value of {@code children} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder children(DeviceManagementConfigurationSettingInstanceTemplate... children) {
            return children(Arrays.asList(children));
        }

        /**
         * <i>“Option Children”</i>
         * 
         * @param childrenNextLink
         *            value of {@code children@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childrenNextLink(String childrenNextLink) {
            this.childrenNextLink = childrenNextLink;
            this.changedFields = changedFields.add("children");
            return this;
        }

        /**
         * <i>“Default Constant Value”</i>
         * 
         * @param settingDefinitionOptionId
         *            value of {@code settingDefinitionOptionId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDefinitionOptionId(String settingDefinitionOptionId) {
            this.settingDefinitionOptionId = settingDefinitionOptionId;
            this.changedFields = changedFields.add("settingDefinitionOptionId");
            return this;
        }

        public DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate build() {
            DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate _x = new DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate";
            _x.children = children;
            _x.childrenNextLink = childrenNextLink;
            _x.settingDefinitionOptionId = settingDefinitionOptionId;
            return _x;
        }
    }

    private DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate _copy() {
        DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate _x = new DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.children = children;
        _x.settingDefinitionOptionId = settingDefinitionOptionId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationChoiceSettingValueConstantDefaultTemplate[");
        b.append("children=");
        b.append(this.children);
        b.append(", ");
        b.append("settingDefinitionOptionId=");
        b.append(this.settingDefinitionOptionId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
