package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Choice Setting Collection Instance Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowUnmanagedValues", 
    "choiceSettingCollectionValueTemplate"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate extends DeviceManagementConfigurationSettingInstanceTemplate implements ODataType {

    @JsonProperty("allowUnmanagedValues")
    protected Boolean allowUnmanagedValues;

    @JsonProperty("choiceSettingCollectionValueTemplate")
    protected List<DeviceManagementConfigurationChoiceSettingValueTemplate> choiceSettingCollectionValueTemplate;

    @JsonProperty("choiceSettingCollectionValueTemplate@nextLink")
    protected String choiceSettingCollectionValueTemplateNextLink;

    protected DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationChoiceSettingCollectionInstanceTemplate";
    }

    /**
     * <i>“Linked policy may append values which are not present in the template.”</i>
     * 
     * @return property allowUnmanagedValues
     */
    @Property(name="allowUnmanagedValues")
    @JsonIgnore
    public Optional<Boolean> getAllowUnmanagedValues() {
        return Optional.ofNullable(allowUnmanagedValues);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowUnmanagedValues} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Linked policy may append values which are not present in the template.”</i>
     * 
     * @param allowUnmanagedValues
     *            new value of {@code allowUnmanagedValues} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowUnmanagedValues} field changed
     */
    public DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate withAllowUnmanagedValues(Boolean allowUnmanagedValues) {
        DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationChoiceSettingCollectionInstanceTemplate");
        _x.allowUnmanagedValues = allowUnmanagedValues;
        return _x;
    }

    /**
     * <i>“Choice Setting Collection Value Template”</i>
     * 
     * @return property choiceSettingCollectionValueTemplate
     */
    @Property(name="choiceSettingCollectionValueTemplate")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationChoiceSettingValueTemplate> getChoiceSettingCollectionValueTemplate() {
        return new CollectionPage<DeviceManagementConfigurationChoiceSettingValueTemplate>(contextPath, DeviceManagementConfigurationChoiceSettingValueTemplate.class, this.choiceSettingCollectionValueTemplate, Optional.ofNullable(choiceSettingCollectionValueTemplateNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Choice Setting Collection Value Template”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property choiceSettingCollectionValueTemplate
     */
    @Property(name="choiceSettingCollectionValueTemplate")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationChoiceSettingValueTemplate> getChoiceSettingCollectionValueTemplate(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationChoiceSettingValueTemplate>(contextPath, DeviceManagementConfigurationChoiceSettingValueTemplate.class, this.choiceSettingCollectionValueTemplate, Optional.ofNullable(choiceSettingCollectionValueTemplateNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isRequired;
        private String settingDefinitionId;
        private String settingInstanceTemplateId;
        private Boolean allowUnmanagedValues;
        private List<DeviceManagementConfigurationChoiceSettingValueTemplate> choiceSettingCollectionValueTemplate;
        private String choiceSettingCollectionValueTemplateNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder settingDefinitionId(String settingDefinitionId) {
            this.settingDefinitionId = settingDefinitionId;
            this.changedFields = changedFields.add("settingDefinitionId");
            return this;
        }

        public Builder settingInstanceTemplateId(String settingInstanceTemplateId) {
            this.settingInstanceTemplateId = settingInstanceTemplateId;
            this.changedFields = changedFields.add("settingInstanceTemplateId");
            return this;
        }

        /**
         * <i>“Linked policy may append values which are not present in the template.”</i>
         * 
         * @param allowUnmanagedValues
         *            value of {@code allowUnmanagedValues} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowUnmanagedValues(Boolean allowUnmanagedValues) {
            this.allowUnmanagedValues = allowUnmanagedValues;
            this.changedFields = changedFields.add("allowUnmanagedValues");
            return this;
        }

        /**
         * <i>“Choice Setting Collection Value Template”</i>
         * 
         * @param choiceSettingCollectionValueTemplate
         *            value of {@code choiceSettingCollectionValueTemplate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder choiceSettingCollectionValueTemplate(List<DeviceManagementConfigurationChoiceSettingValueTemplate> choiceSettingCollectionValueTemplate) {
            this.choiceSettingCollectionValueTemplate = choiceSettingCollectionValueTemplate;
            this.changedFields = changedFields.add("choiceSettingCollectionValueTemplate");
            return this;
        }

        /**
         * <i>“Choice Setting Collection Value Template”</i>
         * 
         * @param choiceSettingCollectionValueTemplate
         *            value of {@code choiceSettingCollectionValueTemplate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder choiceSettingCollectionValueTemplate(DeviceManagementConfigurationChoiceSettingValueTemplate... choiceSettingCollectionValueTemplate) {
            return choiceSettingCollectionValueTemplate(Arrays.asList(choiceSettingCollectionValueTemplate));
        }

        /**
         * <i>“Choice Setting Collection Value Template”</i>
         * 
         * @param choiceSettingCollectionValueTemplateNextLink
         *            value of {@code choiceSettingCollectionValueTemplate@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder choiceSettingCollectionValueTemplateNextLink(String choiceSettingCollectionValueTemplateNextLink) {
            this.choiceSettingCollectionValueTemplateNextLink = choiceSettingCollectionValueTemplateNextLink;
            this.changedFields = changedFields.add("choiceSettingCollectionValueTemplate");
            return this;
        }

        public DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate build() {
            DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate _x = new DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationChoiceSettingCollectionInstanceTemplate";
            _x.isRequired = isRequired;
            _x.settingDefinitionId = settingDefinitionId;
            _x.settingInstanceTemplateId = settingInstanceTemplateId;
            _x.allowUnmanagedValues = allowUnmanagedValues;
            _x.choiceSettingCollectionValueTemplate = choiceSettingCollectionValueTemplate;
            _x.choiceSettingCollectionValueTemplateNextLink = choiceSettingCollectionValueTemplateNextLink;
            return _x;
        }
    }

    private DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate _copy() {
        DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate _x = new DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isRequired = isRequired;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstanceTemplateId = settingInstanceTemplateId;
        _x.allowUnmanagedValues = allowUnmanagedValues;
        _x.choiceSettingCollectionValueTemplate = choiceSettingCollectionValueTemplate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationChoiceSettingCollectionInstanceTemplate[");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstanceTemplateId=");
        b.append(this.settingInstanceTemplateId);
        b.append(", ");
        b.append("allowUnmanagedValues=");
        b.append(this.allowUnmanagedValues);
        b.append(", ");
        b.append("choiceSettingCollectionValueTemplate=");
        b.append(this.choiceSettingCollectionValueTemplate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
