package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Setting instance within policy”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "choiceSettingCollectionValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationChoiceSettingCollectionInstance extends DeviceManagementConfigurationSettingInstance implements ODataType {

    @JsonProperty("choiceSettingCollectionValue")
    protected List<DeviceManagementConfigurationChoiceSettingValue> choiceSettingCollectionValue;

    @JsonProperty("choiceSettingCollectionValue@nextLink")
    protected String choiceSettingCollectionValueNextLink;

    protected DeviceManagementConfigurationChoiceSettingCollectionInstance() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationChoiceSettingCollectionInstance";
    }

    /**
     * <i>“Choice setting collection value”</i>
     * 
     * @return property choiceSettingCollectionValue
     */
    @Property(name="choiceSettingCollectionValue")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationChoiceSettingValue> getChoiceSettingCollectionValue() {
        return new CollectionPage<DeviceManagementConfigurationChoiceSettingValue>(contextPath, DeviceManagementConfigurationChoiceSettingValue.class, this.choiceSettingCollectionValue, Optional.ofNullable(choiceSettingCollectionValueNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Choice setting collection value”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property choiceSettingCollectionValue
     */
    @Property(name="choiceSettingCollectionValue")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationChoiceSettingValue> getChoiceSettingCollectionValue(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationChoiceSettingValue>(contextPath, DeviceManagementConfigurationChoiceSettingValue.class, this.choiceSettingCollectionValue, Optional.ofNullable(choiceSettingCollectionValueNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementConfigurationChoiceSettingCollectionInstance withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationChoiceSettingCollectionInstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationChoiceSettingCollectionInstance() {
        return new Builder();
    }

    public static final class Builder {
        private String settingDefinitionId;
        private DeviceManagementConfigurationSettingInstanceTemplateReference settingInstanceTemplateReference;
        private List<DeviceManagementConfigurationChoiceSettingValue> choiceSettingCollectionValue;
        private String choiceSettingCollectionValueNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder settingDefinitionId(String settingDefinitionId) {
            this.settingDefinitionId = settingDefinitionId;
            this.changedFields = changedFields.add("settingDefinitionId");
            return this;
        }

        public Builder settingInstanceTemplateReference(DeviceManagementConfigurationSettingInstanceTemplateReference settingInstanceTemplateReference) {
            this.settingInstanceTemplateReference = settingInstanceTemplateReference;
            this.changedFields = changedFields.add("settingInstanceTemplateReference");
            return this;
        }

        /**
         * <i>“Choice setting collection value”</i>
         * 
         * @param choiceSettingCollectionValue
         *            value of {@code choiceSettingCollectionValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder choiceSettingCollectionValue(List<DeviceManagementConfigurationChoiceSettingValue> choiceSettingCollectionValue) {
            this.choiceSettingCollectionValue = choiceSettingCollectionValue;
            this.changedFields = changedFields.add("choiceSettingCollectionValue");
            return this;
        }

        /**
         * <i>“Choice setting collection value”</i>
         * 
         * @param choiceSettingCollectionValue
         *            value of {@code choiceSettingCollectionValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder choiceSettingCollectionValue(DeviceManagementConfigurationChoiceSettingValue... choiceSettingCollectionValue) {
            return choiceSettingCollectionValue(Arrays.asList(choiceSettingCollectionValue));
        }

        /**
         * <i>“Choice setting collection value”</i>
         * 
         * @param choiceSettingCollectionValueNextLink
         *            value of {@code choiceSettingCollectionValue@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder choiceSettingCollectionValueNextLink(String choiceSettingCollectionValueNextLink) {
            this.choiceSettingCollectionValueNextLink = choiceSettingCollectionValueNextLink;
            this.changedFields = changedFields.add("choiceSettingCollectionValue");
            return this;
        }

        public DeviceManagementConfigurationChoiceSettingCollectionInstance build() {
            DeviceManagementConfigurationChoiceSettingCollectionInstance _x = new DeviceManagementConfigurationChoiceSettingCollectionInstance();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationChoiceSettingCollectionInstance";
            _x.settingDefinitionId = settingDefinitionId;
            _x.settingInstanceTemplateReference = settingInstanceTemplateReference;
            _x.choiceSettingCollectionValue = choiceSettingCollectionValue;
            _x.choiceSettingCollectionValueNextLink = choiceSettingCollectionValueNextLink;
            return _x;
        }
    }

    private DeviceManagementConfigurationChoiceSettingCollectionInstance _copy() {
        DeviceManagementConfigurationChoiceSettingCollectionInstance _x = new DeviceManagementConfigurationChoiceSettingCollectionInstance();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstanceTemplateReference = settingInstanceTemplateReference;
        _x.choiceSettingCollectionValue = choiceSettingCollectionValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationChoiceSettingCollectionInstance[");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstanceTemplateReference=");
        b.append(this.settingInstanceTemplateReference);
        b.append(", ");
        b.append("choiceSettingCollectionValue=");
        b.append(this.choiceSettingCollectionValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
