package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementApplicabilityRuleType;

@JsonPropertyOrder({
    "@odata.type", 
    "maxOSVersion", 
    "minOSVersion", 
    "name", 
    "ruleType"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementApplicabilityRuleOsVersion implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("maxOSVersion")
    protected String maxOSVersion;

    @JsonProperty("minOSVersion")
    protected String minOSVersion;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("ruleType")
    protected DeviceManagementApplicabilityRuleType ruleType;

    protected DeviceManagementApplicabilityRuleOsVersion() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementApplicabilityRuleOsVersion";
    }

    /**
     * <i>“Max OS version for Applicability Rule.”</i>
     * 
     * @return property maxOSVersion
     */
    @Property(name="maxOSVersion")
    @JsonIgnore
    public Optional<String> getMaxOSVersion() {
        return Optional.ofNullable(maxOSVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maxOSVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Max OS version for Applicability Rule.”</i>
     * 
     * @param maxOSVersion
     *            new value of {@code maxOSVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maxOSVersion} field changed
     */
    public DeviceManagementApplicabilityRuleOsVersion withMaxOSVersion(String maxOSVersion) {
        DeviceManagementApplicabilityRuleOsVersion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementApplicabilityRuleOsVersion");
        _x.maxOSVersion = maxOSVersion;
        return _x;
    }

    /**
     * <i>“Min OS version for Applicability Rule.”</i>
     * 
     * @return property minOSVersion
     */
    @Property(name="minOSVersion")
    @JsonIgnore
    public Optional<String> getMinOSVersion() {
        return Optional.ofNullable(minOSVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code minOSVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Min OS version for Applicability Rule.”</i>
     * 
     * @param minOSVersion
     *            new value of {@code minOSVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minOSVersion} field changed
     */
    public DeviceManagementApplicabilityRuleOsVersion withMinOSVersion(String minOSVersion) {
        DeviceManagementApplicabilityRuleOsVersion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementApplicabilityRuleOsVersion");
        _x.minOSVersion = minOSVersion;
        return _x;
    }

    /**
     * <i>“Name for object.”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name for object.”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public DeviceManagementApplicabilityRuleOsVersion withName(String name) {
        DeviceManagementApplicabilityRuleOsVersion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementApplicabilityRuleOsVersion");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Applicability Rule type.”</i>
     * 
     * @return property ruleType
     */
    @Property(name="ruleType")
    @JsonIgnore
    public Optional<DeviceManagementApplicabilityRuleType> getRuleType() {
        return Optional.ofNullable(ruleType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ruleType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Applicability Rule type.”</i>
     * 
     * @param ruleType
     *            new value of {@code ruleType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ruleType} field changed
     */
    public DeviceManagementApplicabilityRuleOsVersion withRuleType(DeviceManagementApplicabilityRuleType ruleType) {
        DeviceManagementApplicabilityRuleOsVersion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementApplicabilityRuleOsVersion");
        _x.ruleType = ruleType;
        return _x;
    }

    public DeviceManagementApplicabilityRuleOsVersion withUnmappedField(String name, Object value) {
        DeviceManagementApplicabilityRuleOsVersion _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String maxOSVersion;
        private String minOSVersion;
        private String name;
        private DeviceManagementApplicabilityRuleType ruleType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Max OS version for Applicability Rule.”</i>
         * 
         * @param maxOSVersion
         *            value of {@code maxOSVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maxOSVersion(String maxOSVersion) {
            this.maxOSVersion = maxOSVersion;
            this.changedFields = changedFields.add("maxOSVersion");
            return this;
        }

        /**
         * <i>“Min OS version for Applicability Rule.”</i>
         * 
         * @param minOSVersion
         *            value of {@code minOSVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minOSVersion(String minOSVersion) {
            this.minOSVersion = minOSVersion;
            this.changedFields = changedFields.add("minOSVersion");
            return this;
        }

        /**
         * <i>“Name for object.”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Applicability Rule type.”</i>
         * 
         * @param ruleType
         *            value of {@code ruleType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ruleType(DeviceManagementApplicabilityRuleType ruleType) {
            this.ruleType = ruleType;
            this.changedFields = changedFields.add("ruleType");
            return this;
        }

        public DeviceManagementApplicabilityRuleOsVersion build() {
            DeviceManagementApplicabilityRuleOsVersion _x = new DeviceManagementApplicabilityRuleOsVersion();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementApplicabilityRuleOsVersion";
            _x.maxOSVersion = maxOSVersion;
            _x.minOSVersion = minOSVersion;
            _x.name = name;
            _x.ruleType = ruleType;
            return _x;
        }
    }

    private DeviceManagementApplicabilityRuleOsVersion _copy() {
        DeviceManagementApplicabilityRuleOsVersion _x = new DeviceManagementApplicabilityRuleOsVersion();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.maxOSVersion = maxOSVersion;
        _x.minOSVersion = minOSVersion;
        _x.name = name;
        _x.ruleType = ruleType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementApplicabilityRuleOsVersion[");
        b.append("maxOSVersion=");
        b.append(this.maxOSVersion);
        b.append(", ");
        b.append("minOSVersion=");
        b.append(this.minOSVersion);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("ruleType=");
        b.append(this.ruleType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
