package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceLogCollectionTemplateType;


/**
 * <i>“Windows Log Collection request entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "templateType"})
@JsonInclude(Include.NON_NULL)
public class DeviceLogCollectionRequest implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("templateType")
    protected DeviceLogCollectionTemplateType templateType;

    protected DeviceLogCollectionRequest() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceLogCollectionRequest";
    }

    /**
     * <i>“The unique identifier”</i>
     * 
     * @return property id
     */
    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code id} field changed
     * . Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The unique identifier”</i>
     * 
     * @param id
     *            new value of {@code id} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code id} field changed
     */
    public DeviceLogCollectionRequest withId(String id) {
        DeviceLogCollectionRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceLogCollectionRequest");
        _x.id = id;
        return _x;
    }

    /**
     * <i>“The template type that is sent with the collection request”</i>
     * 
     * @return property templateType
     */
    @Property(name="templateType")
    @JsonIgnore
    public Optional<DeviceLogCollectionTemplateType> getTemplateType() {
        return Optional.ofNullable(templateType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code templateType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The template type that is sent with the collection request”</i>
     * 
     * @param templateType
     *            new value of {@code templateType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code templateType} field changed
     */
    public DeviceLogCollectionRequest withTemplateType(DeviceLogCollectionTemplateType templateType) {
        DeviceLogCollectionRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceLogCollectionRequest");
        _x.templateType = templateType;
        return _x;
    }

    public DeviceLogCollectionRequest withUnmappedField(String name, Object value) {
        DeviceLogCollectionRequest _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceLogCollectionTemplateType templateType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The unique identifier”</i>
         * 
         * @param id
         *            value of {@code id} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The template type that is sent with the collection request”</i>
         * 
         * @param templateType
         *            value of {@code templateType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templateType(DeviceLogCollectionTemplateType templateType) {
            this.templateType = templateType;
            this.changedFields = changedFields.add("templateType");
            return this;
        }

        public DeviceLogCollectionRequest build() {
            DeviceLogCollectionRequest _x = new DeviceLogCollectionRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceLogCollectionRequest";
            _x.id = id;
            _x.templateType = templateType;
            return _x;
        }
    }

    private DeviceLogCollectionRequest _copy() {
        DeviceLogCollectionRequest _x = new DeviceLogCollectionRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.templateType = templateType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceLogCollectionRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("templateType=");
        b.append(this.templateType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
