package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Optional;


/**
 * <i>“Device health script run once schedule.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "date"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptRunOnceSchedule extends DeviceHealthScriptTimeSchedule implements ODataType {

    @JsonProperty("date")
    protected LocalDate date;

    protected DeviceHealthScriptRunOnceSchedule() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptRunOnceSchedule";
    }

    /**
     * <i>“The date the script is scheduled to run. This collection can contain a maximum
     * of 20 elements.”</i>
     * 
     * @return property date
     */
    @Property(name="date")
    @JsonIgnore
    public Optional<LocalDate> getDate() {
        return Optional.ofNullable(date);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code date} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The date the script is scheduled to run. This collection can contain a maximum
     * of 20 elements.”</i>
     * 
     * @param date
     *            new value of {@code date} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code date} field changed
     */
    public DeviceHealthScriptRunOnceSchedule withDate(LocalDate date) {
        DeviceHealthScriptRunOnceSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunOnceSchedule");
        _x.date = date;
        return _x;
    }

    public DeviceHealthScriptRunOnceSchedule withUnmappedField(String name, Object value) {
        DeviceHealthScriptRunOnceSchedule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceHealthScriptRunOnceSchedule() {
        return new Builder();
    }

    public static final class Builder {
        private Integer interval;
        private LocalTime time;
        private Boolean useUtc;
        private LocalDate date;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder interval(Integer interval) {
            this.interval = interval;
            this.changedFields = changedFields.add("interval");
            return this;
        }

        public Builder time(LocalTime time) {
            this.time = time;
            this.changedFields = changedFields.add("time");
            return this;
        }

        public Builder useUtc(Boolean useUtc) {
            this.useUtc = useUtc;
            this.changedFields = changedFields.add("useUtc");
            return this;
        }

        /**
         * <i>“The date the script is scheduled to run. This collection can contain a maximum
         * of 20 elements.”</i>
         * 
         * @param date
         *            value of {@code date} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder date(LocalDate date) {
            this.date = date;
            this.changedFields = changedFields.add("date");
            return this;
        }

        public DeviceHealthScriptRunOnceSchedule build() {
            DeviceHealthScriptRunOnceSchedule _x = new DeviceHealthScriptRunOnceSchedule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceHealthScriptRunOnceSchedule";
            _x.interval = interval;
            _x.time = time;
            _x.useUtc = useUtc;
            _x.date = date;
            return _x;
        }
    }

    private DeviceHealthScriptRunOnceSchedule _copy() {
        DeviceHealthScriptRunOnceSchedule _x = new DeviceHealthScriptRunOnceSchedule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.interval = interval;
        _x.time = time;
        _x.useUtc = useUtc;
        _x.date = date;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptRunOnceSchedule[");
        b.append("interval=");
        b.append(this.interval);
        b.append(", ");
        b.append("time=");
        b.append(this.time);
        b.append(", ");
        b.append("useUtc=");
        b.append(this.useUtc);
        b.append(", ");
        b.append("date=");
        b.append(this.date);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
