package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The number of device health scripts deployed and the number of devices the
 * scripts remediated.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "remediatedDeviceCount", 
    "scriptCount"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptRemediationSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("remediatedDeviceCount")
    protected Integer remediatedDeviceCount;

    @JsonProperty("scriptCount")
    protected Integer scriptCount;

    protected DeviceHealthScriptRemediationSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptRemediationSummary";
    }

    /**
     * <i>“The number of devices remediated by device health scripts.”</i>
     * 
     * @return property remediatedDeviceCount
     */
    @Property(name="remediatedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getRemediatedDeviceCount() {
        return Optional.ofNullable(remediatedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediatedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of devices remediated by device health scripts.”</i>
     * 
     * @param remediatedDeviceCount
     *            new value of {@code remediatedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediatedDeviceCount} field changed
     */
    public DeviceHealthScriptRemediationSummary withRemediatedDeviceCount(Integer remediatedDeviceCount) {
        DeviceHealthScriptRemediationSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRemediationSummary");
        _x.remediatedDeviceCount = remediatedDeviceCount;
        return _x;
    }

    /**
     * <i>“The number of device health scripts deployed.”</i>
     * 
     * @return property scriptCount
     */
    @Property(name="scriptCount")
    @JsonIgnore
    public Optional<Integer> getScriptCount() {
        return Optional.ofNullable(scriptCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code scriptCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of device health scripts deployed.”</i>
     * 
     * @param scriptCount
     *            new value of {@code scriptCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scriptCount} field changed
     */
    public DeviceHealthScriptRemediationSummary withScriptCount(Integer scriptCount) {
        DeviceHealthScriptRemediationSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRemediationSummary");
        _x.scriptCount = scriptCount;
        return _x;
    }

    public DeviceHealthScriptRemediationSummary withUnmappedField(String name, Object value) {
        DeviceHealthScriptRemediationSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer remediatedDeviceCount;
        private Integer scriptCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The number of devices remediated by device health scripts.”</i>
         * 
         * @param remediatedDeviceCount
         *            value of {@code remediatedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediatedDeviceCount(Integer remediatedDeviceCount) {
            this.remediatedDeviceCount = remediatedDeviceCount;
            this.changedFields = changedFields.add("remediatedDeviceCount");
            return this;
        }

        /**
         * <i>“The number of device health scripts deployed.”</i>
         * 
         * @param scriptCount
         *            value of {@code scriptCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scriptCount(Integer scriptCount) {
            this.scriptCount = scriptCount;
            this.changedFields = changedFields.add("scriptCount");
            return this;
        }

        public DeviceHealthScriptRemediationSummary build() {
            DeviceHealthScriptRemediationSummary _x = new DeviceHealthScriptRemediationSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceHealthScriptRemediationSummary";
            _x.remediatedDeviceCount = remediatedDeviceCount;
            _x.scriptCount = scriptCount;
            return _x;
        }
    }

    private DeviceHealthScriptRemediationSummary _copy() {
        DeviceHealthScriptRemediationSummary _x = new DeviceHealthScriptRemediationSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.remediatedDeviceCount = remediatedDeviceCount;
        _x.scriptCount = scriptCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptRemediationSummary[");
        b.append("remediatedDeviceCount=");
        b.append(this.remediatedDeviceCount);
        b.append(", ");
        b.append("scriptCount=");
        b.append(this.scriptCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
