package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“The number of devices remediated by a device health script on a given date with
 * the last modified time.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "historyData", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptRemediationHistory implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("historyData")
    protected List<DeviceHealthScriptRemediationHistoryData> historyData;

    @JsonProperty("historyData@nextLink")
    protected String historyDataNextLink;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected DeviceHealthScriptRemediationHistory() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptRemediationHistory";
    }

    /**
     * <i>“The number of devices remediated by the device health script on the given date.”</i>
     * 
     * @return property historyData
     */
    @Property(name="historyData")
    @JsonIgnore
    public CollectionPage<DeviceHealthScriptRemediationHistoryData> getHistoryData() {
        return new CollectionPage<DeviceHealthScriptRemediationHistoryData>(contextPath, DeviceHealthScriptRemediationHistoryData.class, this.historyData, Optional.ofNullable(historyDataNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The number of devices remediated by the device health script on the given date.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property historyData
     */
    @Property(name="historyData")
    @JsonIgnore
    public CollectionPage<DeviceHealthScriptRemediationHistoryData> getHistoryData(HttpRequestOptions options) {
        return new CollectionPage<DeviceHealthScriptRemediationHistoryData>(contextPath, DeviceHealthScriptRemediationHistoryData.class, this.historyData, Optional.ofNullable(historyDataNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The date on which the results history is calculated for the healthscript.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date on which the results history is calculated for the healthscript.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceHealthScriptRemediationHistory withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceHealthScriptRemediationHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRemediationHistory");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    public DeviceHealthScriptRemediationHistory withUnmappedField(String name, Object value) {
        DeviceHealthScriptRemediationHistory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DeviceHealthScriptRemediationHistoryData> historyData;
        private String historyDataNextLink;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The number of devices remediated by the device health script on the given date.”</i>
         * 
         * @param historyData
         *            value of {@code historyData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder historyData(List<DeviceHealthScriptRemediationHistoryData> historyData) {
            this.historyData = historyData;
            this.changedFields = changedFields.add("historyData");
            return this;
        }

        /**
         * <i>“The number of devices remediated by the device health script on the given date.”</i>
         * 
         * @param historyData
         *            value of {@code historyData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder historyData(DeviceHealthScriptRemediationHistoryData... historyData) {
            return historyData(Arrays.asList(historyData));
        }

        /**
         * <i>“The number of devices remediated by the device health script on the given date.”</i>
         * 
         * @param historyDataNextLink
         *            value of {@code historyData@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder historyDataNextLink(String historyDataNextLink) {
            this.historyDataNextLink = historyDataNextLink;
            this.changedFields = changedFields.add("historyData");
            return this;
        }

        /**
         * <i>“The date on which the results history is calculated for the healthscript.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public DeviceHealthScriptRemediationHistory build() {
            DeviceHealthScriptRemediationHistory _x = new DeviceHealthScriptRemediationHistory();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceHealthScriptRemediationHistory";
            _x.historyData = historyData;
            _x.historyDataNextLink = historyDataNextLink;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    private DeviceHealthScriptRemediationHistory _copy() {
        DeviceHealthScriptRemediationHistory _x = new DeviceHealthScriptRemediationHistory();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.historyData = historyData;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptRemediationHistory[");
        b.append("historyData=");
        b.append(this.historyData);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
