package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Properties of the  Integer script parameter.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "defaultValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptIntegerParameter extends DeviceHealthScriptParameter implements ODataType {

    @JsonProperty("defaultValue")
    protected Integer defaultValue;

    protected DeviceHealthScriptIntegerParameter() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptIntegerParameter";
    }

    /**
     * <i>“The default value of Integer param. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property defaultValue
     */
    @Property(name="defaultValue")
    @JsonIgnore
    public Optional<Integer> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The default value of Integer param. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param defaultValue
     *            new value of {@code defaultValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultValue} field changed
     */
    public DeviceHealthScriptIntegerParameter withDefaultValue(Integer defaultValue) {
        DeviceHealthScriptIntegerParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptIntegerParameter");
        _x.defaultValue = defaultValue;
        return _x;
    }

    public DeviceHealthScriptIntegerParameter withUnmappedField(String name, Object value) {
        DeviceHealthScriptIntegerParameter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceHealthScriptIntegerParameter() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean applyDefaultValueWhenNotAssigned;
        private String description;
        private Boolean isRequired;
        private String name;
        private Integer defaultValue;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder applyDefaultValueWhenNotAssigned(Boolean applyDefaultValueWhenNotAssigned) {
            this.applyDefaultValueWhenNotAssigned = applyDefaultValueWhenNotAssigned;
            this.changedFields = changedFields.add("applyDefaultValueWhenNotAssigned");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“The default value of Integer param. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param defaultValue
         *            value of {@code defaultValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultValue(Integer defaultValue) {
            this.defaultValue = defaultValue;
            this.changedFields = changedFields.add("defaultValue");
            return this;
        }

        public DeviceHealthScriptIntegerParameter build() {
            DeviceHealthScriptIntegerParameter _x = new DeviceHealthScriptIntegerParameter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceHealthScriptIntegerParameter";
            _x.applyDefaultValueWhenNotAssigned = applyDefaultValueWhenNotAssigned;
            _x.description = description;
            _x.isRequired = isRequired;
            _x.name = name;
            _x.defaultValue = defaultValue;
            return _x;
        }
    }

    private DeviceHealthScriptIntegerParameter _copy() {
        DeviceHealthScriptIntegerParameter _x = new DeviceHealthScriptIntegerParameter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.applyDefaultValueWhenNotAssigned = applyDefaultValueWhenNotAssigned;
        _x.description = description;
        _x.isRequired = isRequired;
        _x.name = name;
        _x.defaultValue = defaultValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptIntegerParameter[");
        b.append("applyDefaultValueWhenNotAssigned=");
        b.append(this.applyDefaultValueWhenNotAssigned);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("defaultValue=");
        b.append(this.defaultValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
