package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;


/**
 * <i>“Type of Device health script hourly schedule.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptHourlySchedule extends DeviceHealthScriptRunSchedule implements ODataType {

    protected DeviceHealthScriptHourlySchedule() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptHourlySchedule";
    }

    public DeviceHealthScriptHourlySchedule withUnmappedField(String name, Object value) {
        DeviceHealthScriptHourlySchedule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceHealthScriptHourlySchedule() {
        return new Builder();
    }

    public static final class Builder {
        private Integer interval;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder interval(Integer interval) {
            this.interval = interval;
            this.changedFields = changedFields.add("interval");
            return this;
        }

        public DeviceHealthScriptHourlySchedule build() {
            DeviceHealthScriptHourlySchedule _x = new DeviceHealthScriptHourlySchedule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceHealthScriptHourlySchedule";
            _x.interval = interval;
            return _x;
        }
    }

    private DeviceHealthScriptHourlySchedule _copy() {
        DeviceHealthScriptHourlySchedule _x = new DeviceHealthScriptHourlySchedule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.interval = interval;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptHourlySchedule[");
        b.append("interval=");
        b.append(this.interval);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
