package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "attestationIdentityKey", 
    "bitLockerStatus", 
    "bootAppSecurityVersion", 
    "bootDebugging", 
    "bootManagerSecurityVersion", 
    "bootManagerVersion", 
    "bootRevisionListInfo", 
    "codeIntegrity", 
    "codeIntegrityCheckVersion", 
    "codeIntegrityPolicy", 
    "contentNamespaceUrl", 
    "contentVersion", 
    "dataExcutionPolicy", 
    "deviceHealthAttestationStatus", 
    "earlyLaunchAntiMalwareDriverProtection", 
    "healthAttestationSupportedStatus", 
    "healthStatusMismatchInfo", 
    "issuedDateTime", 
    "lastUpdateDateTime", 
    "operatingSystemKernelDebugging", 
    "operatingSystemRevListInfo", 
    "pcr0", 
    "pcrHashAlgorithm", 
    "resetCount", 
    "restartCount", 
    "safeMode", 
    "secureBoot", 
    "secureBootConfigurationPolicyFingerPrint", 
    "testSigning", 
    "tpmVersion", 
    "virtualSecureMode", 
    "windowsPE"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthAttestationState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("attestationIdentityKey")
    protected String attestationIdentityKey;

    @JsonProperty("bitLockerStatus")
    protected String bitLockerStatus;

    @JsonProperty("bootAppSecurityVersion")
    protected String bootAppSecurityVersion;

    @JsonProperty("bootDebugging")
    protected String bootDebugging;

    @JsonProperty("bootManagerSecurityVersion")
    protected String bootManagerSecurityVersion;

    @JsonProperty("bootManagerVersion")
    protected String bootManagerVersion;

    @JsonProperty("bootRevisionListInfo")
    protected String bootRevisionListInfo;

    @JsonProperty("codeIntegrity")
    protected String codeIntegrity;

    @JsonProperty("codeIntegrityCheckVersion")
    protected String codeIntegrityCheckVersion;

    @JsonProperty("codeIntegrityPolicy")
    protected String codeIntegrityPolicy;

    @JsonProperty("contentNamespaceUrl")
    protected String contentNamespaceUrl;

    @JsonProperty("contentVersion")
    protected String contentVersion;

    @JsonProperty("dataExcutionPolicy")
    protected String dataExcutionPolicy;

    @JsonProperty("deviceHealthAttestationStatus")
    protected String deviceHealthAttestationStatus;

    @JsonProperty("earlyLaunchAntiMalwareDriverProtection")
    protected String earlyLaunchAntiMalwareDriverProtection;

    @JsonProperty("healthAttestationSupportedStatus")
    protected String healthAttestationSupportedStatus;

    @JsonProperty("healthStatusMismatchInfo")
    protected String healthStatusMismatchInfo;

    @JsonProperty("issuedDateTime")
    protected OffsetDateTime issuedDateTime;

    @JsonProperty("lastUpdateDateTime")
    protected String lastUpdateDateTime;

    @JsonProperty("operatingSystemKernelDebugging")
    protected String operatingSystemKernelDebugging;

    @JsonProperty("operatingSystemRevListInfo")
    protected String operatingSystemRevListInfo;

    @JsonProperty("pcr0")
    protected String pcr0;

    @JsonProperty("pcrHashAlgorithm")
    protected String pcrHashAlgorithm;

    @JsonProperty("resetCount")
    protected Long resetCount;

    @JsonProperty("restartCount")
    protected Long restartCount;

    @JsonProperty("safeMode")
    protected String safeMode;

    @JsonProperty("secureBoot")
    protected String secureBoot;

    @JsonProperty("secureBootConfigurationPolicyFingerPrint")
    protected String secureBootConfigurationPolicyFingerPrint;

    @JsonProperty("testSigning")
    protected String testSigning;

    @JsonProperty("tpmVersion")
    protected String tpmVersion;

    @JsonProperty("virtualSecureMode")
    protected String virtualSecureMode;

    @JsonProperty("windowsPE")
    protected String windowsPE;

    protected DeviceHealthAttestationState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthAttestationState";
    }

    /**
     * <i>“TWhen an Attestation Identity Key (AIK) is present on a device, it indicates
     * that the device has an endorsement key (EK) certificate.”</i>
     * 
     * @return property attestationIdentityKey
     */
    @Property(name="attestationIdentityKey")
    @JsonIgnore
    public Optional<String> getAttestationIdentityKey() {
        return Optional.ofNullable(attestationIdentityKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * attestationIdentityKey} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“TWhen an Attestation Identity Key (AIK) is present on a device, it indicates
     * that the device has an endorsement key (EK) certificate.”</i>
     * 
     * @param attestationIdentityKey
     *            new value of {@code attestationIdentityKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code attestationIdentityKey} field changed
     */
    public DeviceHealthAttestationState withAttestationIdentityKey(String attestationIdentityKey) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.attestationIdentityKey = attestationIdentityKey;
        return _x;
    }

    /**
     * <i>“On or Off of BitLocker Drive Encryption”</i>
     * 
     * @return property bitLockerStatus
     */
    @Property(name="bitLockerStatus")
    @JsonIgnore
    public Optional<String> getBitLockerStatus() {
        return Optional.ofNullable(bitLockerStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bitLockerStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“On or Off of BitLocker Drive Encryption”</i>
     * 
     * @param bitLockerStatus
     *            new value of {@code bitLockerStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bitLockerStatus} field changed
     */
    public DeviceHealthAttestationState withBitLockerStatus(String bitLockerStatus) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.bitLockerStatus = bitLockerStatus;
        return _x;
    }

    /**
     * <i>“The security version number of the Boot Application”</i>
     * 
     * @return property bootAppSecurityVersion
     */
    @Property(name="bootAppSecurityVersion")
    @JsonIgnore
    public Optional<String> getBootAppSecurityVersion() {
        return Optional.ofNullable(bootAppSecurityVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bootAppSecurityVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The security version number of the Boot Application”</i>
     * 
     * @param bootAppSecurityVersion
     *            new value of {@code bootAppSecurityVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bootAppSecurityVersion} field changed
     */
    public DeviceHealthAttestationState withBootAppSecurityVersion(String bootAppSecurityVersion) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.bootAppSecurityVersion = bootAppSecurityVersion;
        return _x;
    }

    /**
     * <i>“When bootDebugging is enabled, the device is used in development and testing”</i>
     * 
     * @return property bootDebugging
     */
    @Property(name="bootDebugging")
    @JsonIgnore
    public Optional<String> getBootDebugging() {
        return Optional.ofNullable(bootDebugging);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bootDebugging}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“When bootDebugging is enabled, the device is used in development and testing”</i>
     * 
     * @param bootDebugging
     *            new value of {@code bootDebugging} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bootDebugging} field changed
     */
    public DeviceHealthAttestationState withBootDebugging(String bootDebugging) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.bootDebugging = bootDebugging;
        return _x;
    }

    /**
     * <i>“The security version number of the Boot Application”</i>
     * 
     * @return property bootManagerSecurityVersion
     */
    @Property(name="bootManagerSecurityVersion")
    @JsonIgnore
    public Optional<String> getBootManagerSecurityVersion() {
        return Optional.ofNullable(bootManagerSecurityVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bootManagerSecurityVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The security version number of the Boot Application”</i>
     * 
     * @param bootManagerSecurityVersion
     *            new value of {@code bootManagerSecurityVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bootManagerSecurityVersion} field changed
     */
    public DeviceHealthAttestationState withBootManagerSecurityVersion(String bootManagerSecurityVersion) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.bootManagerSecurityVersion = bootManagerSecurityVersion;
        return _x;
    }

    /**
     * <i>“The version of the Boot Manager”</i>
     * 
     * @return property bootManagerVersion
     */
    @Property(name="bootManagerVersion")
    @JsonIgnore
    public Optional<String> getBootManagerVersion() {
        return Optional.ofNullable(bootManagerVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bootManagerVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The version of the Boot Manager”</i>
     * 
     * @param bootManagerVersion
     *            new value of {@code bootManagerVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bootManagerVersion} field changed
     */
    public DeviceHealthAttestationState withBootManagerVersion(String bootManagerVersion) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.bootManagerVersion = bootManagerVersion;
        return _x;
    }

    /**
     * <i>“The Boot Revision List that was loaded during initial boot on the attested
     * device”</i>
     * 
     * @return property bootRevisionListInfo
     */
    @Property(name="bootRevisionListInfo")
    @JsonIgnore
    public Optional<String> getBootRevisionListInfo() {
        return Optional.ofNullable(bootRevisionListInfo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bootRevisionListInfo} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Boot Revision List that was loaded during initial boot on the attested
     * device”</i>
     * 
     * @param bootRevisionListInfo
     *            new value of {@code bootRevisionListInfo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bootRevisionListInfo} field changed
     */
    public DeviceHealthAttestationState withBootRevisionListInfo(String bootRevisionListInfo) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.bootRevisionListInfo = bootRevisionListInfo;
        return _x;
    }

    /**
     * <i>“When code integrity is enabled, code execution is restricted to integrity
     * verified code”</i>
     * 
     * @return property codeIntegrity
     */
    @Property(name="codeIntegrity")
    @JsonIgnore
    public Optional<String> getCodeIntegrity() {
        return Optional.ofNullable(codeIntegrity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code codeIntegrity}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“When code integrity is enabled, code execution is restricted to integrity
     * verified code”</i>
     * 
     * @param codeIntegrity
     *            new value of {@code codeIntegrity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code codeIntegrity} field changed
     */
    public DeviceHealthAttestationState withCodeIntegrity(String codeIntegrity) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.codeIntegrity = codeIntegrity;
        return _x;
    }

    /**
     * <i>“The version of the Boot Manager”</i>
     * 
     * @return property codeIntegrityCheckVersion
     */
    @Property(name="codeIntegrityCheckVersion")
    @JsonIgnore
    public Optional<String> getCodeIntegrityCheckVersion() {
        return Optional.ofNullable(codeIntegrityCheckVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * codeIntegrityCheckVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The version of the Boot Manager”</i>
     * 
     * @param codeIntegrityCheckVersion
     *            new value of {@code codeIntegrityCheckVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code codeIntegrityCheckVersion} field changed
     */
    public DeviceHealthAttestationState withCodeIntegrityCheckVersion(String codeIntegrityCheckVersion) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.codeIntegrityCheckVersion = codeIntegrityCheckVersion;
        return _x;
    }

    /**
     * <i>“The Code Integrity policy that is controlling the security of the boot
     * environment”</i>
     * 
     * @return property codeIntegrityPolicy
     */
    @Property(name="codeIntegrityPolicy")
    @JsonIgnore
    public Optional<String> getCodeIntegrityPolicy() {
        return Optional.ofNullable(codeIntegrityPolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * codeIntegrityPolicy} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Code Integrity policy that is controlling the security of the boot
     * environment”</i>
     * 
     * @param codeIntegrityPolicy
     *            new value of {@code codeIntegrityPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code codeIntegrityPolicy} field changed
     */
    public DeviceHealthAttestationState withCodeIntegrityPolicy(String codeIntegrityPolicy) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.codeIntegrityPolicy = codeIntegrityPolicy;
        return _x;
    }

    /**
     * <i>“The DHA report version. (Namespace version)”</i>
     * 
     * @return property contentNamespaceUrl
     */
    @Property(name="contentNamespaceUrl")
    @JsonIgnore
    public Optional<String> getContentNamespaceUrl() {
        return Optional.ofNullable(contentNamespaceUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentNamespaceUrl} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The DHA report version. (Namespace version)”</i>
     * 
     * @param contentNamespaceUrl
     *            new value of {@code contentNamespaceUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentNamespaceUrl} field changed
     */
    public DeviceHealthAttestationState withContentNamespaceUrl(String contentNamespaceUrl) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.contentNamespaceUrl = contentNamespaceUrl;
        return _x;
    }

    /**
     * <i>“The HealthAttestation state schema version”</i>
     * 
     * @return property contentVersion
     */
    @Property(name="contentVersion")
    @JsonIgnore
    public Optional<String> getContentVersion() {
        return Optional.ofNullable(contentVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code contentVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The HealthAttestation state schema version”</i>
     * 
     * @param contentVersion
     *            new value of {@code contentVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentVersion} field changed
     */
    public DeviceHealthAttestationState withContentVersion(String contentVersion) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.contentVersion = contentVersion;
        return _x;
    }

    /**
     * <i>“DEP Policy defines a set of hardware and software technologies that perform
     * additional checks on memory”</i>
     * 
     * @return property dataExcutionPolicy
     */
    @Property(name="dataExcutionPolicy")
    @JsonIgnore
    public Optional<String> getDataExcutionPolicy() {
        return Optional.ofNullable(dataExcutionPolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * dataExcutionPolicy} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DEP Policy defines a set of hardware and software technologies that perform
     * additional checks on memory”</i>
     * 
     * @param dataExcutionPolicy
     *            new value of {@code dataExcutionPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataExcutionPolicy} field changed
     */
    public DeviceHealthAttestationState withDataExcutionPolicy(String dataExcutionPolicy) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.dataExcutionPolicy = dataExcutionPolicy;
        return _x;
    }

    /**
     * <i>“The DHA report version. (Namespace version)”</i>
     * 
     * @return property deviceHealthAttestationStatus
     */
    @Property(name="deviceHealthAttestationStatus")
    @JsonIgnore
    public Optional<String> getDeviceHealthAttestationStatus() {
        return Optional.ofNullable(deviceHealthAttestationStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceHealthAttestationStatus} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The DHA report version. (Namespace version)”</i>
     * 
     * @param deviceHealthAttestationStatus
     *            new value of {@code deviceHealthAttestationStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceHealthAttestationStatus} field changed
     */
    public DeviceHealthAttestationState withDeviceHealthAttestationStatus(String deviceHealthAttestationStatus) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.deviceHealthAttestationStatus = deviceHealthAttestationStatus;
        return _x;
    }

    /**
     * <i>“ELAM provides protection for the computers in your network when they start up”</i>
     * 
     * @return property earlyLaunchAntiMalwareDriverProtection
     */
    @Property(name="earlyLaunchAntiMalwareDriverProtection")
    @JsonIgnore
    public Optional<String> getEarlyLaunchAntiMalwareDriverProtection() {
        return Optional.ofNullable(earlyLaunchAntiMalwareDriverProtection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * earlyLaunchAntiMalwareDriverProtection} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“ELAM provides protection for the computers in your network when they start up”</i>
     * 
     * @param earlyLaunchAntiMalwareDriverProtection
     *            new value of {@code earlyLaunchAntiMalwareDriverProtection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code earlyLaunchAntiMalwareDriverProtection} field changed
     */
    public DeviceHealthAttestationState withEarlyLaunchAntiMalwareDriverProtection(String earlyLaunchAntiMalwareDriverProtection) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.earlyLaunchAntiMalwareDriverProtection = earlyLaunchAntiMalwareDriverProtection;
        return _x;
    }

    /**
     * <i>“This attribute indicates if DHA is supported for the device”</i>
     * 
     * @return property healthAttestationSupportedStatus
     */
    @Property(name="healthAttestationSupportedStatus")
    @JsonIgnore
    public Optional<String> getHealthAttestationSupportedStatus() {
        return Optional.ofNullable(healthAttestationSupportedStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * healthAttestationSupportedStatus} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This attribute indicates if DHA is supported for the device”</i>
     * 
     * @param healthAttestationSupportedStatus
     *            new value of {@code healthAttestationSupportedStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthAttestationSupportedStatus} field changed
     */
    public DeviceHealthAttestationState withHealthAttestationSupportedStatus(String healthAttestationSupportedStatus) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.healthAttestationSupportedStatus = healthAttestationSupportedStatus;
        return _x;
    }

    /**
     * <i>“This attribute appears if DHA-Service detects an integrity issue”</i>
     * 
     * @return property healthStatusMismatchInfo
     */
    @Property(name="healthStatusMismatchInfo")
    @JsonIgnore
    public Optional<String> getHealthStatusMismatchInfo() {
        return Optional.ofNullable(healthStatusMismatchInfo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * healthStatusMismatchInfo} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This attribute appears if DHA-Service detects an integrity issue”</i>
     * 
     * @param healthStatusMismatchInfo
     *            new value of {@code healthStatusMismatchInfo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthStatusMismatchInfo} field changed
     */
    public DeviceHealthAttestationState withHealthStatusMismatchInfo(String healthStatusMismatchInfo) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.healthStatusMismatchInfo = healthStatusMismatchInfo;
        return _x;
    }

    /**
     * <i>“The DateTime when device was evaluated or issued to MDM”</i>
     * 
     * @return property issuedDateTime
     */
    @Property(name="issuedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getIssuedDateTime() {
        return Optional.ofNullable(issuedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code issuedDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The DateTime when device was evaluated or issued to MDM”</i>
     * 
     * @param issuedDateTime
     *            new value of {@code issuedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code issuedDateTime} field changed
     */
    public DeviceHealthAttestationState withIssuedDateTime(OffsetDateTime issuedDateTime) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.issuedDateTime = issuedDateTime;
        return _x;
    }

    /**
     * <i>“The Timestamp of the last update.”</i>
     * 
     * @return property lastUpdateDateTime
     */
    @Property(name="lastUpdateDateTime")
    @JsonIgnore
    public Optional<String> getLastUpdateDateTime() {
        return Optional.ofNullable(lastUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdateDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Timestamp of the last update.”</i>
     * 
     * @param lastUpdateDateTime
     *            new value of {@code lastUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdateDateTime} field changed
     */
    public DeviceHealthAttestationState withLastUpdateDateTime(String lastUpdateDateTime) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.lastUpdateDateTime = lastUpdateDateTime;
        return _x;
    }

    /**
     * <i>“When operatingSystemKernelDebugging is enabled, the device is used in
     * development and testing”</i>
     * 
     * @return property operatingSystemKernelDebugging
     */
    @Property(name="operatingSystemKernelDebugging")
    @JsonIgnore
    public Optional<String> getOperatingSystemKernelDebugging() {
        return Optional.ofNullable(operatingSystemKernelDebugging);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * operatingSystemKernelDebugging} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“When operatingSystemKernelDebugging is enabled, the device is used in
     * development and testing”</i>
     * 
     * @param operatingSystemKernelDebugging
     *            new value of {@code operatingSystemKernelDebugging} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystemKernelDebugging} field changed
     */
    public DeviceHealthAttestationState withOperatingSystemKernelDebugging(String operatingSystemKernelDebugging) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.operatingSystemKernelDebugging = operatingSystemKernelDebugging;
        return _x;
    }

    /**
     * <i>“The Operating System Revision List that was loaded during initial boot on the
     * attested device”</i>
     * 
     * @return property operatingSystemRevListInfo
     */
    @Property(name="operatingSystemRevListInfo")
    @JsonIgnore
    public Optional<String> getOperatingSystemRevListInfo() {
        return Optional.ofNullable(operatingSystemRevListInfo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * operatingSystemRevListInfo} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Operating System Revision List that was loaded during initial boot on the
     * attested device”</i>
     * 
     * @param operatingSystemRevListInfo
     *            new value of {@code operatingSystemRevListInfo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystemRevListInfo} field changed
     */
    public DeviceHealthAttestationState withOperatingSystemRevListInfo(String operatingSystemRevListInfo) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.operatingSystemRevListInfo = operatingSystemRevListInfo;
        return _x;
    }

    /**
     * <i>“The measurement that is captured in PCR[0]”</i>
     * 
     * @return property pcr0
     */
    @Property(name="pcr0")
    @JsonIgnore
    public Optional<String> getPcr0() {
        return Optional.ofNullable(pcr0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code pcr0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The measurement that is captured in PCR[0]”</i>
     * 
     * @param pcr0
     *            new value of {@code pcr0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pcr0} field changed
     */
    public DeviceHealthAttestationState withPcr0(String pcr0) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.pcr0 = pcr0;
        return _x;
    }

    /**
     * <i>“Informational attribute that identifies the HASH algorithm that was used by TPM”</i>
     * 
     * @return property pcrHashAlgorithm
     */
    @Property(name="pcrHashAlgorithm")
    @JsonIgnore
    public Optional<String> getPcrHashAlgorithm() {
        return Optional.ofNullable(pcrHashAlgorithm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code pcrHashAlgorithm}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Informational attribute that identifies the HASH algorithm that was used by TPM”</i>
     * 
     * @param pcrHashAlgorithm
     *            new value of {@code pcrHashAlgorithm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pcrHashAlgorithm} field changed
     */
    public DeviceHealthAttestationState withPcrHashAlgorithm(String pcrHashAlgorithm) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.pcrHashAlgorithm = pcrHashAlgorithm;
        return _x;
    }

    /**
     * <i>“The number of times a PC device has hibernated or resumed”</i>
     * 
     * @return property resetCount
     */
    @Property(name="resetCount")
    @JsonIgnore
    public Optional<Long> getResetCount() {
        return Optional.ofNullable(resetCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code resetCount} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The number of times a PC device has hibernated or resumed”</i>
     * 
     * @param resetCount
     *            new value of {@code resetCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resetCount} field changed
     */
    public DeviceHealthAttestationState withResetCount(Long resetCount) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.resetCount = resetCount;
        return _x;
    }

    /**
     * <i>“The number of times a PC device has rebooted”</i>
     * 
     * @return property restartCount
     */
    @Property(name="restartCount")
    @JsonIgnore
    public Optional<Long> getRestartCount() {
        return Optional.ofNullable(restartCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code restartCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of times a PC device has rebooted”</i>
     * 
     * @param restartCount
     *            new value of {@code restartCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restartCount} field changed
     */
    public DeviceHealthAttestationState withRestartCount(Long restartCount) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.restartCount = restartCount;
        return _x;
    }

    /**
     * <i>“Safe mode is a troubleshooting option for Windows that starts your computer in a
     * limited state”</i>
     * 
     * @return property safeMode
     */
    @Property(name="safeMode")
    @JsonIgnore
    public Optional<String> getSafeMode() {
        return Optional.ofNullable(safeMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code safeMode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Safe mode is a troubleshooting option for Windows that starts your computer in a
     * limited state”</i>
     * 
     * @param safeMode
     *            new value of {@code safeMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code safeMode} field changed
     */
    public DeviceHealthAttestationState withSafeMode(String safeMode) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.safeMode = safeMode;
        return _x;
    }

    /**
     * <i>“When Secure Boot is enabled, the core components must have the correct
     * cryptographic signatures”</i>
     * 
     * @return property secureBoot
     */
    @Property(name="secureBoot")
    @JsonIgnore
    public Optional<String> getSecureBoot() {
        return Optional.ofNullable(secureBoot);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code secureBoot} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“When Secure Boot is enabled, the core components must have the correct
     * cryptographic signatures”</i>
     * 
     * @param secureBoot
     *            new value of {@code secureBoot} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code secureBoot} field changed
     */
    public DeviceHealthAttestationState withSecureBoot(String secureBoot) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.secureBoot = secureBoot;
        return _x;
    }

    /**
     * <i>“Fingerprint of the Custom Secure Boot Configuration Policy”</i>
     * 
     * @return property secureBootConfigurationPolicyFingerPrint
     */
    @Property(name="secureBootConfigurationPolicyFingerPrint")
    @JsonIgnore
    public Optional<String> getSecureBootConfigurationPolicyFingerPrint() {
        return Optional.ofNullable(secureBootConfigurationPolicyFingerPrint);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * secureBootConfigurationPolicyFingerPrint} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Fingerprint of the Custom Secure Boot Configuration Policy”</i>
     * 
     * @param secureBootConfigurationPolicyFingerPrint
     *            new value of {@code secureBootConfigurationPolicyFingerPrint} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code secureBootConfigurationPolicyFingerPrint} field changed
     */
    public DeviceHealthAttestationState withSecureBootConfigurationPolicyFingerPrint(String secureBootConfigurationPolicyFingerPrint) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.secureBootConfigurationPolicyFingerPrint = secureBootConfigurationPolicyFingerPrint;
        return _x;
    }

    /**
     * <i>“When test signing is allowed, the device does not enforce signature validation
     * during boot”</i>
     * 
     * @return property testSigning
     */
    @Property(name="testSigning")
    @JsonIgnore
    public Optional<String> getTestSigning() {
        return Optional.ofNullable(testSigning);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code testSigning}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“When test signing is allowed, the device does not enforce signature validation
     * during boot”</i>
     * 
     * @param testSigning
     *            new value of {@code testSigning} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code testSigning} field changed
     */
    public DeviceHealthAttestationState withTestSigning(String testSigning) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.testSigning = testSigning;
        return _x;
    }

    /**
     * <i>“The security version number of the Boot Application”</i>
     * 
     * @return property tpmVersion
     */
    @Property(name="tpmVersion")
    @JsonIgnore
    public Optional<String> getTpmVersion() {
        return Optional.ofNullable(tpmVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tpmVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The security version number of the Boot Application”</i>
     * 
     * @param tpmVersion
     *            new value of {@code tpmVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tpmVersion} field changed
     */
    public DeviceHealthAttestationState withTpmVersion(String tpmVersion) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.tpmVersion = tpmVersion;
        return _x;
    }

    /**
     * <i>“VSM is a container that protects high value assets from a compromised kernel”</i>
     * 
     * @return property virtualSecureMode
     */
    @Property(name="virtualSecureMode")
    @JsonIgnore
    public Optional<String> getVirtualSecureMode() {
        return Optional.ofNullable(virtualSecureMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code virtualSecureMode
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“VSM is a container that protects high value assets from a compromised kernel”</i>
     * 
     * @param virtualSecureMode
     *            new value of {@code virtualSecureMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code virtualSecureMode} field changed
     */
    public DeviceHealthAttestationState withVirtualSecureMode(String virtualSecureMode) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.virtualSecureMode = virtualSecureMode;
        return _x;
    }

    /**
     * <i>“Operating system running with limited services that is used to prepare a
     * computer for Windows”</i>
     * 
     * @return property windowsPE
     */
    @Property(name="windowsPE")
    @JsonIgnore
    public Optional<String> getWindowsPE() {
        return Optional.ofNullable(windowsPE);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code windowsPE} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Operating system running with limited services that is used to prepare a
     * computer for Windows”</i>
     * 
     * @param windowsPE
     *            new value of {@code windowsPE} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsPE} field changed
     */
    public DeviceHealthAttestationState withWindowsPE(String windowsPE) {
        DeviceHealthAttestationState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthAttestationState");
        _x.windowsPE = windowsPE;
        return _x;
    }

    public DeviceHealthAttestationState withUnmappedField(String name, Object value) {
        DeviceHealthAttestationState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String attestationIdentityKey;
        private String bitLockerStatus;
        private String bootAppSecurityVersion;
        private String bootDebugging;
        private String bootManagerSecurityVersion;
        private String bootManagerVersion;
        private String bootRevisionListInfo;
        private String codeIntegrity;
        private String codeIntegrityCheckVersion;
        private String codeIntegrityPolicy;
        private String contentNamespaceUrl;
        private String contentVersion;
        private String dataExcutionPolicy;
        private String deviceHealthAttestationStatus;
        private String earlyLaunchAntiMalwareDriverProtection;
        private String healthAttestationSupportedStatus;
        private String healthStatusMismatchInfo;
        private OffsetDateTime issuedDateTime;
        private String lastUpdateDateTime;
        private String operatingSystemKernelDebugging;
        private String operatingSystemRevListInfo;
        private String pcr0;
        private String pcrHashAlgorithm;
        private Long resetCount;
        private Long restartCount;
        private String safeMode;
        private String secureBoot;
        private String secureBootConfigurationPolicyFingerPrint;
        private String testSigning;
        private String tpmVersion;
        private String virtualSecureMode;
        private String windowsPE;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“TWhen an Attestation Identity Key (AIK) is present on a device, it indicates
         * that the device has an endorsement key (EK) certificate.”</i>
         * 
         * @param attestationIdentityKey
         *            value of {@code attestationIdentityKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder attestationIdentityKey(String attestationIdentityKey) {
            this.attestationIdentityKey = attestationIdentityKey;
            this.changedFields = changedFields.add("attestationIdentityKey");
            return this;
        }

        /**
         * <i>“On or Off of BitLocker Drive Encryption”</i>
         * 
         * @param bitLockerStatus
         *            value of {@code bitLockerStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bitLockerStatus(String bitLockerStatus) {
            this.bitLockerStatus = bitLockerStatus;
            this.changedFields = changedFields.add("bitLockerStatus");
            return this;
        }

        /**
         * <i>“The security version number of the Boot Application”</i>
         * 
         * @param bootAppSecurityVersion
         *            value of {@code bootAppSecurityVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bootAppSecurityVersion(String bootAppSecurityVersion) {
            this.bootAppSecurityVersion = bootAppSecurityVersion;
            this.changedFields = changedFields.add("bootAppSecurityVersion");
            return this;
        }

        /**
         * <i>“When bootDebugging is enabled, the device is used in development and testing”</i>
         * 
         * @param bootDebugging
         *            value of {@code bootDebugging} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bootDebugging(String bootDebugging) {
            this.bootDebugging = bootDebugging;
            this.changedFields = changedFields.add("bootDebugging");
            return this;
        }

        /**
         * <i>“The security version number of the Boot Application”</i>
         * 
         * @param bootManagerSecurityVersion
         *            value of {@code bootManagerSecurityVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bootManagerSecurityVersion(String bootManagerSecurityVersion) {
            this.bootManagerSecurityVersion = bootManagerSecurityVersion;
            this.changedFields = changedFields.add("bootManagerSecurityVersion");
            return this;
        }

        /**
         * <i>“The version of the Boot Manager”</i>
         * 
         * @param bootManagerVersion
         *            value of {@code bootManagerVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bootManagerVersion(String bootManagerVersion) {
            this.bootManagerVersion = bootManagerVersion;
            this.changedFields = changedFields.add("bootManagerVersion");
            return this;
        }

        /**
         * <i>“The Boot Revision List that was loaded during initial boot on the attested
         * device”</i>
         * 
         * @param bootRevisionListInfo
         *            value of {@code bootRevisionListInfo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bootRevisionListInfo(String bootRevisionListInfo) {
            this.bootRevisionListInfo = bootRevisionListInfo;
            this.changedFields = changedFields.add("bootRevisionListInfo");
            return this;
        }

        /**
         * <i>“When code integrity is enabled, code execution is restricted to integrity
         * verified code”</i>
         * 
         * @param codeIntegrity
         *            value of {@code codeIntegrity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder codeIntegrity(String codeIntegrity) {
            this.codeIntegrity = codeIntegrity;
            this.changedFields = changedFields.add("codeIntegrity");
            return this;
        }

        /**
         * <i>“The version of the Boot Manager”</i>
         * 
         * @param codeIntegrityCheckVersion
         *            value of {@code codeIntegrityCheckVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder codeIntegrityCheckVersion(String codeIntegrityCheckVersion) {
            this.codeIntegrityCheckVersion = codeIntegrityCheckVersion;
            this.changedFields = changedFields.add("codeIntegrityCheckVersion");
            return this;
        }

        /**
         * <i>“The Code Integrity policy that is controlling the security of the boot
         * environment”</i>
         * 
         * @param codeIntegrityPolicy
         *            value of {@code codeIntegrityPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder codeIntegrityPolicy(String codeIntegrityPolicy) {
            this.codeIntegrityPolicy = codeIntegrityPolicy;
            this.changedFields = changedFields.add("codeIntegrityPolicy");
            return this;
        }

        /**
         * <i>“The DHA report version. (Namespace version)”</i>
         * 
         * @param contentNamespaceUrl
         *            value of {@code contentNamespaceUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentNamespaceUrl(String contentNamespaceUrl) {
            this.contentNamespaceUrl = contentNamespaceUrl;
            this.changedFields = changedFields.add("contentNamespaceUrl");
            return this;
        }

        /**
         * <i>“The HealthAttestation state schema version”</i>
         * 
         * @param contentVersion
         *            value of {@code contentVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentVersion(String contentVersion) {
            this.contentVersion = contentVersion;
            this.changedFields = changedFields.add("contentVersion");
            return this;
        }

        /**
         * <i>“DEP Policy defines a set of hardware and software technologies that perform
         * additional checks on memory”</i>
         * 
         * @param dataExcutionPolicy
         *            value of {@code dataExcutionPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataExcutionPolicy(String dataExcutionPolicy) {
            this.dataExcutionPolicy = dataExcutionPolicy;
            this.changedFields = changedFields.add("dataExcutionPolicy");
            return this;
        }

        /**
         * <i>“The DHA report version. (Namespace version)”</i>
         * 
         * @param deviceHealthAttestationStatus
         *            value of {@code deviceHealthAttestationStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceHealthAttestationStatus(String deviceHealthAttestationStatus) {
            this.deviceHealthAttestationStatus = deviceHealthAttestationStatus;
            this.changedFields = changedFields.add("deviceHealthAttestationStatus");
            return this;
        }

        /**
         * <i>“ELAM provides protection for the computers in your network when they start up”</i>
         * 
         * @param earlyLaunchAntiMalwareDriverProtection
         *            value of {@code earlyLaunchAntiMalwareDriverProtection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder earlyLaunchAntiMalwareDriverProtection(String earlyLaunchAntiMalwareDriverProtection) {
            this.earlyLaunchAntiMalwareDriverProtection = earlyLaunchAntiMalwareDriverProtection;
            this.changedFields = changedFields.add("earlyLaunchAntiMalwareDriverProtection");
            return this;
        }

        /**
         * <i>“This attribute indicates if DHA is supported for the device”</i>
         * 
         * @param healthAttestationSupportedStatus
         *            value of {@code healthAttestationSupportedStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthAttestationSupportedStatus(String healthAttestationSupportedStatus) {
            this.healthAttestationSupportedStatus = healthAttestationSupportedStatus;
            this.changedFields = changedFields.add("healthAttestationSupportedStatus");
            return this;
        }

        /**
         * <i>“This attribute appears if DHA-Service detects an integrity issue”</i>
         * 
         * @param healthStatusMismatchInfo
         *            value of {@code healthStatusMismatchInfo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthStatusMismatchInfo(String healthStatusMismatchInfo) {
            this.healthStatusMismatchInfo = healthStatusMismatchInfo;
            this.changedFields = changedFields.add("healthStatusMismatchInfo");
            return this;
        }

        /**
         * <i>“The DateTime when device was evaluated or issued to MDM”</i>
         * 
         * @param issuedDateTime
         *            value of {@code issuedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder issuedDateTime(OffsetDateTime issuedDateTime) {
            this.issuedDateTime = issuedDateTime;
            this.changedFields = changedFields.add("issuedDateTime");
            return this;
        }

        /**
         * <i>“The Timestamp of the last update.”</i>
         * 
         * @param lastUpdateDateTime
         *            value of {@code lastUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdateDateTime(String lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            this.changedFields = changedFields.add("lastUpdateDateTime");
            return this;
        }

        /**
         * <i>“When operatingSystemKernelDebugging is enabled, the device is used in
         * development and testing”</i>
         * 
         * @param operatingSystemKernelDebugging
         *            value of {@code operatingSystemKernelDebugging} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemKernelDebugging(String operatingSystemKernelDebugging) {
            this.operatingSystemKernelDebugging = operatingSystemKernelDebugging;
            this.changedFields = changedFields.add("operatingSystemKernelDebugging");
            return this;
        }

        /**
         * <i>“The Operating System Revision List that was loaded during initial boot on the
         * attested device”</i>
         * 
         * @param operatingSystemRevListInfo
         *            value of {@code operatingSystemRevListInfo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemRevListInfo(String operatingSystemRevListInfo) {
            this.operatingSystemRevListInfo = operatingSystemRevListInfo;
            this.changedFields = changedFields.add("operatingSystemRevListInfo");
            return this;
        }

        /**
         * <i>“The measurement that is captured in PCR[0]”</i>
         * 
         * @param pcr0
         *            value of {@code pcr0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pcr0(String pcr0) {
            this.pcr0 = pcr0;
            this.changedFields = changedFields.add("pcr0");
            return this;
        }

        /**
         * <i>“Informational attribute that identifies the HASH algorithm that was used by TPM”</i>
         * 
         * @param pcrHashAlgorithm
         *            value of {@code pcrHashAlgorithm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pcrHashAlgorithm(String pcrHashAlgorithm) {
            this.pcrHashAlgorithm = pcrHashAlgorithm;
            this.changedFields = changedFields.add("pcrHashAlgorithm");
            return this;
        }

        /**
         * <i>“The number of times a PC device has hibernated or resumed”</i>
         * 
         * @param resetCount
         *            value of {@code resetCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resetCount(Long resetCount) {
            this.resetCount = resetCount;
            this.changedFields = changedFields.add("resetCount");
            return this;
        }

        /**
         * <i>“The number of times a PC device has rebooted”</i>
         * 
         * @param restartCount
         *            value of {@code restartCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restartCount(Long restartCount) {
            this.restartCount = restartCount;
            this.changedFields = changedFields.add("restartCount");
            return this;
        }

        /**
         * <i>“Safe mode is a troubleshooting option for Windows that starts your computer in a
         * limited state”</i>
         * 
         * @param safeMode
         *            value of {@code safeMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safeMode(String safeMode) {
            this.safeMode = safeMode;
            this.changedFields = changedFields.add("safeMode");
            return this;
        }

        /**
         * <i>“When Secure Boot is enabled, the core components must have the correct
         * cryptographic signatures”</i>
         * 
         * @param secureBoot
         *            value of {@code secureBoot} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder secureBoot(String secureBoot) {
            this.secureBoot = secureBoot;
            this.changedFields = changedFields.add("secureBoot");
            return this;
        }

        /**
         * <i>“Fingerprint of the Custom Secure Boot Configuration Policy”</i>
         * 
         * @param secureBootConfigurationPolicyFingerPrint
         *            value of {@code secureBootConfigurationPolicyFingerPrint} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder secureBootConfigurationPolicyFingerPrint(String secureBootConfigurationPolicyFingerPrint) {
            this.secureBootConfigurationPolicyFingerPrint = secureBootConfigurationPolicyFingerPrint;
            this.changedFields = changedFields.add("secureBootConfigurationPolicyFingerPrint");
            return this;
        }

        /**
         * <i>“When test signing is allowed, the device does not enforce signature validation
         * during boot”</i>
         * 
         * @param testSigning
         *            value of {@code testSigning} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder testSigning(String testSigning) {
            this.testSigning = testSigning;
            this.changedFields = changedFields.add("testSigning");
            return this;
        }

        /**
         * <i>“The security version number of the Boot Application”</i>
         * 
         * @param tpmVersion
         *            value of {@code tpmVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tpmVersion(String tpmVersion) {
            this.tpmVersion = tpmVersion;
            this.changedFields = changedFields.add("tpmVersion");
            return this;
        }

        /**
         * <i>“VSM is a container that protects high value assets from a compromised kernel”</i>
         * 
         * @param virtualSecureMode
         *            value of {@code virtualSecureMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder virtualSecureMode(String virtualSecureMode) {
            this.virtualSecureMode = virtualSecureMode;
            this.changedFields = changedFields.add("virtualSecureMode");
            return this;
        }

        /**
         * <i>“Operating system running with limited services that is used to prepare a
         * computer for Windows”</i>
         * 
         * @param windowsPE
         *            value of {@code windowsPE} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsPE(String windowsPE) {
            this.windowsPE = windowsPE;
            this.changedFields = changedFields.add("windowsPE");
            return this;
        }

        public DeviceHealthAttestationState build() {
            DeviceHealthAttestationState _x = new DeviceHealthAttestationState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceHealthAttestationState";
            _x.attestationIdentityKey = attestationIdentityKey;
            _x.bitLockerStatus = bitLockerStatus;
            _x.bootAppSecurityVersion = bootAppSecurityVersion;
            _x.bootDebugging = bootDebugging;
            _x.bootManagerSecurityVersion = bootManagerSecurityVersion;
            _x.bootManagerVersion = bootManagerVersion;
            _x.bootRevisionListInfo = bootRevisionListInfo;
            _x.codeIntegrity = codeIntegrity;
            _x.codeIntegrityCheckVersion = codeIntegrityCheckVersion;
            _x.codeIntegrityPolicy = codeIntegrityPolicy;
            _x.contentNamespaceUrl = contentNamespaceUrl;
            _x.contentVersion = contentVersion;
            _x.dataExcutionPolicy = dataExcutionPolicy;
            _x.deviceHealthAttestationStatus = deviceHealthAttestationStatus;
            _x.earlyLaunchAntiMalwareDriverProtection = earlyLaunchAntiMalwareDriverProtection;
            _x.healthAttestationSupportedStatus = healthAttestationSupportedStatus;
            _x.healthStatusMismatchInfo = healthStatusMismatchInfo;
            _x.issuedDateTime = issuedDateTime;
            _x.lastUpdateDateTime = lastUpdateDateTime;
            _x.operatingSystemKernelDebugging = operatingSystemKernelDebugging;
            _x.operatingSystemRevListInfo = operatingSystemRevListInfo;
            _x.pcr0 = pcr0;
            _x.pcrHashAlgorithm = pcrHashAlgorithm;
            _x.resetCount = resetCount;
            _x.restartCount = restartCount;
            _x.safeMode = safeMode;
            _x.secureBoot = secureBoot;
            _x.secureBootConfigurationPolicyFingerPrint = secureBootConfigurationPolicyFingerPrint;
            _x.testSigning = testSigning;
            _x.tpmVersion = tpmVersion;
            _x.virtualSecureMode = virtualSecureMode;
            _x.windowsPE = windowsPE;
            return _x;
        }
    }

    private DeviceHealthAttestationState _copy() {
        DeviceHealthAttestationState _x = new DeviceHealthAttestationState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attestationIdentityKey = attestationIdentityKey;
        _x.bitLockerStatus = bitLockerStatus;
        _x.bootAppSecurityVersion = bootAppSecurityVersion;
        _x.bootDebugging = bootDebugging;
        _x.bootManagerSecurityVersion = bootManagerSecurityVersion;
        _x.bootManagerVersion = bootManagerVersion;
        _x.bootRevisionListInfo = bootRevisionListInfo;
        _x.codeIntegrity = codeIntegrity;
        _x.codeIntegrityCheckVersion = codeIntegrityCheckVersion;
        _x.codeIntegrityPolicy = codeIntegrityPolicy;
        _x.contentNamespaceUrl = contentNamespaceUrl;
        _x.contentVersion = contentVersion;
        _x.dataExcutionPolicy = dataExcutionPolicy;
        _x.deviceHealthAttestationStatus = deviceHealthAttestationStatus;
        _x.earlyLaunchAntiMalwareDriverProtection = earlyLaunchAntiMalwareDriverProtection;
        _x.healthAttestationSupportedStatus = healthAttestationSupportedStatus;
        _x.healthStatusMismatchInfo = healthStatusMismatchInfo;
        _x.issuedDateTime = issuedDateTime;
        _x.lastUpdateDateTime = lastUpdateDateTime;
        _x.operatingSystemKernelDebugging = operatingSystemKernelDebugging;
        _x.operatingSystemRevListInfo = operatingSystemRevListInfo;
        _x.pcr0 = pcr0;
        _x.pcrHashAlgorithm = pcrHashAlgorithm;
        _x.resetCount = resetCount;
        _x.restartCount = restartCount;
        _x.safeMode = safeMode;
        _x.secureBoot = secureBoot;
        _x.secureBootConfigurationPolicyFingerPrint = secureBootConfigurationPolicyFingerPrint;
        _x.testSigning = testSigning;
        _x.tpmVersion = tpmVersion;
        _x.virtualSecureMode = virtualSecureMode;
        _x.windowsPE = windowsPE;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthAttestationState[");
        b.append("attestationIdentityKey=");
        b.append(this.attestationIdentityKey);
        b.append(", ");
        b.append("bitLockerStatus=");
        b.append(this.bitLockerStatus);
        b.append(", ");
        b.append("bootAppSecurityVersion=");
        b.append(this.bootAppSecurityVersion);
        b.append(", ");
        b.append("bootDebugging=");
        b.append(this.bootDebugging);
        b.append(", ");
        b.append("bootManagerSecurityVersion=");
        b.append(this.bootManagerSecurityVersion);
        b.append(", ");
        b.append("bootManagerVersion=");
        b.append(this.bootManagerVersion);
        b.append(", ");
        b.append("bootRevisionListInfo=");
        b.append(this.bootRevisionListInfo);
        b.append(", ");
        b.append("codeIntegrity=");
        b.append(this.codeIntegrity);
        b.append(", ");
        b.append("codeIntegrityCheckVersion=");
        b.append(this.codeIntegrityCheckVersion);
        b.append(", ");
        b.append("codeIntegrityPolicy=");
        b.append(this.codeIntegrityPolicy);
        b.append(", ");
        b.append("contentNamespaceUrl=");
        b.append(this.contentNamespaceUrl);
        b.append(", ");
        b.append("contentVersion=");
        b.append(this.contentVersion);
        b.append(", ");
        b.append("dataExcutionPolicy=");
        b.append(this.dataExcutionPolicy);
        b.append(", ");
        b.append("deviceHealthAttestationStatus=");
        b.append(this.deviceHealthAttestationStatus);
        b.append(", ");
        b.append("earlyLaunchAntiMalwareDriverProtection=");
        b.append(this.earlyLaunchAntiMalwareDriverProtection);
        b.append(", ");
        b.append("healthAttestationSupportedStatus=");
        b.append(this.healthAttestationSupportedStatus);
        b.append(", ");
        b.append("healthStatusMismatchInfo=");
        b.append(this.healthStatusMismatchInfo);
        b.append(", ");
        b.append("issuedDateTime=");
        b.append(this.issuedDateTime);
        b.append(", ");
        b.append("lastUpdateDateTime=");
        b.append(this.lastUpdateDateTime);
        b.append(", ");
        b.append("operatingSystemKernelDebugging=");
        b.append(this.operatingSystemKernelDebugging);
        b.append(", ");
        b.append("operatingSystemRevListInfo=");
        b.append(this.operatingSystemRevListInfo);
        b.append(", ");
        b.append("pcr0=");
        b.append(this.pcr0);
        b.append(", ");
        b.append("pcrHashAlgorithm=");
        b.append(this.pcrHashAlgorithm);
        b.append(", ");
        b.append("resetCount=");
        b.append(this.resetCount);
        b.append(", ");
        b.append("restartCount=");
        b.append(this.restartCount);
        b.append(", ");
        b.append("safeMode=");
        b.append(this.safeMode);
        b.append(", ");
        b.append("secureBoot=");
        b.append(this.secureBoot);
        b.append(", ");
        b.append("secureBootConfigurationPolicyFingerPrint=");
        b.append(this.secureBootConfigurationPolicyFingerPrint);
        b.append(", ");
        b.append("testSigning=");
        b.append(this.testSigning);
        b.append(", ");
        b.append("tpmVersion=");
        b.append(this.tpmVersion);
        b.append(", ");
        b.append("virtualSecureMode=");
        b.append(this.virtualSecureMode);
        b.append(", ");
        b.append("windowsPE=");
        b.append(this.windowsPE);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
