package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "lastConnectionTime"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealth implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("lastConnectionTime")
    protected OffsetDateTime lastConnectionTime;

    protected DeviceHealth() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealth";
    }

    @Property(name="lastConnectionTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastConnectionTime() {
        return Optional.ofNullable(lastConnectionTime);
    }

    public DeviceHealth withLastConnectionTime(OffsetDateTime lastConnectionTime) {
        DeviceHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealth");
        _x.lastConnectionTime = lastConnectionTime;
        return _x;
    }

    public DeviceHealth withUnmappedField(String name, Object value) {
        DeviceHealth _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime lastConnectionTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder lastConnectionTime(OffsetDateTime lastConnectionTime) {
            this.lastConnectionTime = lastConnectionTime;
            this.changedFields = changedFields.add("lastConnectionTime");
            return this;
        }

        public DeviceHealth build() {
            DeviceHealth _x = new DeviceHealth();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceHealth";
            _x.lastConnectionTime = lastConnectionTime;
            return _x;
        }
    }

    private DeviceHealth _copy() {
        DeviceHealth _x = new DeviceHealth();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lastConnectionTime = lastConnectionTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealth[");
        b.append("lastConnectionTime=");
        b.append(this.lastConnectionTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
