package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "browser", 
    "browserId", 
    "deviceId", 
    "displayName", 
    "isCompliant", 
    "isManaged", 
    "operatingSystem", 
    "trustType"})
@JsonInclude(Include.NON_NULL)
public class DeviceDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("browser")
    protected String browser;

    @JsonProperty("browserId")
    protected String browserId;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isCompliant")
    protected Boolean isCompliant;

    @JsonProperty("isManaged")
    protected Boolean isManaged;

    @JsonProperty("operatingSystem")
    protected String operatingSystem;

    @JsonProperty("trustType")
    protected String trustType;

    protected DeviceDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceDetail";
    }

    @Property(name="browser")
    @JsonIgnore
    public Optional<String> getBrowser() {
        return Optional.ofNullable(browser);
    }

    public DeviceDetail withBrowser(String browser) {
        DeviceDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceDetail");
        _x.browser = browser;
        return _x;
    }

    @Property(name="browserId")
    @JsonIgnore
    public Optional<String> getBrowserId() {
        return Optional.ofNullable(browserId);
    }

    public DeviceDetail withBrowserId(String browserId) {
        DeviceDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceDetail");
        _x.browserId = browserId;
        return _x;
    }

    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    public DeviceDetail withDeviceId(String deviceId) {
        DeviceDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceDetail");
        _x.deviceId = deviceId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public DeviceDetail withDisplayName(String displayName) {
        DeviceDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isCompliant")
    @JsonIgnore
    public Optional<Boolean> getIsCompliant() {
        return Optional.ofNullable(isCompliant);
    }

    public DeviceDetail withIsCompliant(Boolean isCompliant) {
        DeviceDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceDetail");
        _x.isCompliant = isCompliant;
        return _x;
    }

    @Property(name="isManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public DeviceDetail withIsManaged(Boolean isManaged) {
        DeviceDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceDetail");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="operatingSystem")
    @JsonIgnore
    public Optional<String> getOperatingSystem() {
        return Optional.ofNullable(operatingSystem);
    }

    public DeviceDetail withOperatingSystem(String operatingSystem) {
        DeviceDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceDetail");
        _x.operatingSystem = operatingSystem;
        return _x;
    }

    @Property(name="trustType")
    @JsonIgnore
    public Optional<String> getTrustType() {
        return Optional.ofNullable(trustType);
    }

    public DeviceDetail withTrustType(String trustType) {
        DeviceDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceDetail");
        _x.trustType = trustType;
        return _x;
    }

    public DeviceDetail withUnmappedField(String name, Object value) {
        DeviceDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String browser;
        private String browserId;
        private String deviceId;
        private String displayName;
        private Boolean isCompliant;
        private Boolean isManaged;
        private String operatingSystem;
        private String trustType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder browser(String browser) {
            this.browser = browser;
            this.changedFields = changedFields.add("browser");
            return this;
        }

        public Builder browserId(String browserId) {
            this.browserId = browserId;
            this.changedFields = changedFields.add("browserId");
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isCompliant(Boolean isCompliant) {
            this.isCompliant = isCompliant;
            this.changedFields = changedFields.add("isCompliant");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("isManaged");
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.changedFields = changedFields.add("operatingSystem");
            return this;
        }

        public Builder trustType(String trustType) {
            this.trustType = trustType;
            this.changedFields = changedFields.add("trustType");
            return this;
        }

        public DeviceDetail build() {
            DeviceDetail _x = new DeviceDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceDetail";
            _x.browser = browser;
            _x.browserId = browserId;
            _x.deviceId = deviceId;
            _x.displayName = displayName;
            _x.isCompliant = isCompliant;
            _x.isManaged = isManaged;
            _x.operatingSystem = operatingSystem;
            _x.trustType = trustType;
            return _x;
        }
    }

    private DeviceDetail _copy() {
        DeviceDetail _x = new DeviceDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.browser = browser;
        _x.browserId = browserId;
        _x.deviceId = deviceId;
        _x.displayName = displayName;
        _x.isCompliant = isCompliant;
        _x.isManaged = isManaged;
        _x.operatingSystem = operatingSystem;
        _x.trustType = trustType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceDetail[");
        b.append("browser=");
        b.append(this.browser);
        b.append(", ");
        b.append("browserId=");
        b.append(this.browserId);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isCompliant=");
        b.append(this.isCompliant);
        b.append(", ");
        b.append("isManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("operatingSystem=");
        b.append(this.operatingSystem);
        b.append(", ");
        b.append("trustType=");
        b.append(this.trustType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
