package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ruleErrors", 
    "rules", 
    "scriptErrors"})
@JsonInclude(Include.NON_NULL)
public class DeviceComplianceScriptValidationResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ruleErrors")
    protected List<DeviceComplianceScriptRuleError> ruleErrors;

    @JsonProperty("ruleErrors@nextLink")
    protected String ruleErrorsNextLink;

    @JsonProperty("rules")
    protected List<DeviceComplianceScriptRule> rules;

    @JsonProperty("rules@nextLink")
    protected String rulesNextLink;

    @JsonProperty("scriptErrors")
    protected List<DeviceComplianceScriptError> scriptErrors;

    @JsonProperty("scriptErrors@nextLink")
    protected String scriptErrorsNextLink;

    protected DeviceComplianceScriptValidationResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceComplianceScriptValidationResult";
    }

    /**
     * <i>“Errors in json for the script for rules.”</i>
     * 
     * @return property ruleErrors
     */
    @Property(name="ruleErrors")
    @JsonIgnore
    public CollectionPage<DeviceComplianceScriptRuleError> getRuleErrors() {
        return new CollectionPage<DeviceComplianceScriptRuleError>(contextPath, DeviceComplianceScriptRuleError.class, this.ruleErrors, Optional.ofNullable(ruleErrorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Errors in json for the script for rules.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property ruleErrors
     */
    @Property(name="ruleErrors")
    @JsonIgnore
    public CollectionPage<DeviceComplianceScriptRuleError> getRuleErrors(HttpRequestOptions options) {
        return new CollectionPage<DeviceComplianceScriptRuleError>(contextPath, DeviceComplianceScriptRuleError.class, this.ruleErrors, Optional.ofNullable(ruleErrorsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Parsed rules from json.”</i>
     * 
     * @return property rules
     */
    @Property(name="rules")
    @JsonIgnore
    public CollectionPage<DeviceComplianceScriptRule> getRules() {
        return new CollectionPage<DeviceComplianceScriptRule>(contextPath, DeviceComplianceScriptRule.class, this.rules, Optional.ofNullable(rulesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Parsed rules from json.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property rules
     */
    @Property(name="rules")
    @JsonIgnore
    public CollectionPage<DeviceComplianceScriptRule> getRules(HttpRequestOptions options) {
        return new CollectionPage<DeviceComplianceScriptRule>(contextPath, DeviceComplianceScriptRule.class, this.rules, Optional.ofNullable(rulesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Errors in json for the script.”</i>
     * 
     * @return property scriptErrors
     */
    @Property(name="scriptErrors")
    @JsonIgnore
    public CollectionPage<DeviceComplianceScriptError> getScriptErrors() {
        return new CollectionPage<DeviceComplianceScriptError>(contextPath, DeviceComplianceScriptError.class, this.scriptErrors, Optional.ofNullable(scriptErrorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Errors in json for the script.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property scriptErrors
     */
    @Property(name="scriptErrors")
    @JsonIgnore
    public CollectionPage<DeviceComplianceScriptError> getScriptErrors(HttpRequestOptions options) {
        return new CollectionPage<DeviceComplianceScriptError>(contextPath, DeviceComplianceScriptError.class, this.scriptErrors, Optional.ofNullable(scriptErrorsNextLink), Collections.emptyList(), options);
    }

    public DeviceComplianceScriptValidationResult withUnmappedField(String name, Object value) {
        DeviceComplianceScriptValidationResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DeviceComplianceScriptRuleError> ruleErrors;
        private String ruleErrorsNextLink;
        private List<DeviceComplianceScriptRule> rules;
        private String rulesNextLink;
        private List<DeviceComplianceScriptError> scriptErrors;
        private String scriptErrorsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Errors in json for the script for rules.”</i>
         * 
         * @param ruleErrors
         *            value of {@code ruleErrors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ruleErrors(List<DeviceComplianceScriptRuleError> ruleErrors) {
            this.ruleErrors = ruleErrors;
            this.changedFields = changedFields.add("ruleErrors");
            return this;
        }

        /**
         * <i>“Errors in json for the script for rules.”</i>
         * 
         * @param ruleErrors
         *            value of {@code ruleErrors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ruleErrors(DeviceComplianceScriptRuleError... ruleErrors) {
            return ruleErrors(Arrays.asList(ruleErrors));
        }

        /**
         * <i>“Errors in json for the script for rules.”</i>
         * 
         * @param ruleErrorsNextLink
         *            value of {@code ruleErrors@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ruleErrorsNextLink(String ruleErrorsNextLink) {
            this.ruleErrorsNextLink = ruleErrorsNextLink;
            this.changedFields = changedFields.add("ruleErrors");
            return this;
        }

        /**
         * <i>“Parsed rules from json.”</i>
         * 
         * @param rules
         *            value of {@code rules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rules(List<DeviceComplianceScriptRule> rules) {
            this.rules = rules;
            this.changedFields = changedFields.add("rules");
            return this;
        }

        /**
         * <i>“Parsed rules from json.”</i>
         * 
         * @param rules
         *            value of {@code rules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rules(DeviceComplianceScriptRule... rules) {
            return rules(Arrays.asList(rules));
        }

        /**
         * <i>“Parsed rules from json.”</i>
         * 
         * @param rulesNextLink
         *            value of {@code rules@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rulesNextLink(String rulesNextLink) {
            this.rulesNextLink = rulesNextLink;
            this.changedFields = changedFields.add("rules");
            return this;
        }

        /**
         * <i>“Errors in json for the script.”</i>
         * 
         * @param scriptErrors
         *            value of {@code scriptErrors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scriptErrors(List<DeviceComplianceScriptError> scriptErrors) {
            this.scriptErrors = scriptErrors;
            this.changedFields = changedFields.add("scriptErrors");
            return this;
        }

        /**
         * <i>“Errors in json for the script.”</i>
         * 
         * @param scriptErrors
         *            value of {@code scriptErrors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scriptErrors(DeviceComplianceScriptError... scriptErrors) {
            return scriptErrors(Arrays.asList(scriptErrors));
        }

        /**
         * <i>“Errors in json for the script.”</i>
         * 
         * @param scriptErrorsNextLink
         *            value of {@code scriptErrors@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scriptErrorsNextLink(String scriptErrorsNextLink) {
            this.scriptErrorsNextLink = scriptErrorsNextLink;
            this.changedFields = changedFields.add("scriptErrors");
            return this;
        }

        public DeviceComplianceScriptValidationResult build() {
            DeviceComplianceScriptValidationResult _x = new DeviceComplianceScriptValidationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceComplianceScriptValidationResult";
            _x.ruleErrors = ruleErrors;
            _x.ruleErrorsNextLink = ruleErrorsNextLink;
            _x.rules = rules;
            _x.rulesNextLink = rulesNextLink;
            _x.scriptErrors = scriptErrors;
            _x.scriptErrorsNextLink = scriptErrorsNextLink;
            return _x;
        }
    }

    private DeviceComplianceScriptValidationResult _copy() {
        DeviceComplianceScriptValidationResult _x = new DeviceComplianceScriptValidationResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ruleErrors = ruleErrors;
        _x.rules = rules;
        _x.scriptErrors = scriptErrors;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceComplianceScriptValidationResult[");
        b.append("ruleErrors=");
        b.append(this.ruleErrors);
        b.append(", ");
        b.append("rules=");
        b.append(this.rules);
        b.append(", ");
        b.append("scriptErrors=");
        b.append(this.scriptErrors);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
