package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "classification"})
@JsonInclude(Include.NON_NULL)
public class DetectedSensitiveContentWrapper implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("classification")
    protected List<DetectedSensitiveContent> classification;

    @JsonProperty("classification@nextLink")
    protected String classificationNextLink;

    protected DetectedSensitiveContentWrapper() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.detectedSensitiveContentWrapper";
    }

    @Property(name="classification")
    @JsonIgnore
    public CollectionPage<DetectedSensitiveContent> getClassification() {
        return new CollectionPage<DetectedSensitiveContent>(contextPath, DetectedSensitiveContent.class, this.classification, Optional.ofNullable(classificationNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="classification")
    @JsonIgnore
    public CollectionPage<DetectedSensitiveContent> getClassification(HttpRequestOptions options) {
        return new CollectionPage<DetectedSensitiveContent>(contextPath, DetectedSensitiveContent.class, this.classification, Optional.ofNullable(classificationNextLink), Collections.emptyList(), options);
    }

    public DetectedSensitiveContentWrapper withUnmappedField(String name, Object value) {
        DetectedSensitiveContentWrapper _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DetectedSensitiveContent> classification;
        private String classificationNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder classification(List<DetectedSensitiveContent> classification) {
            this.classification = classification;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        public Builder classification(DetectedSensitiveContent... classification) {
            return classification(Arrays.asList(classification));
        }

        public Builder classificationNextLink(String classificationNextLink) {
            this.classificationNextLink = classificationNextLink;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        public DetectedSensitiveContentWrapper build() {
            DetectedSensitiveContentWrapper _x = new DetectedSensitiveContentWrapper();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.detectedSensitiveContentWrapper";
            _x.classification = classification;
            _x.classificationNextLink = classificationNextLink;
            return _x;
        }
    }

    private DetectedSensitiveContentWrapper _copy() {
        DetectedSensitiveContentWrapper _x = new DetectedSensitiveContentWrapper();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.classification = classification;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DetectedSensitiveContentWrapper[");
        b.append("classification=");
        b.append(this.classification);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
