package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "confidence", 
    "displayName", 
    "id", 
    "recommendedConfidence", 
    "uniqueCount"})
@JsonInclude(Include.NON_NULL)
public class DetectedSensitiveContentBase implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("confidence")
    protected Integer confidence;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("id")
    protected UUID id;

    @JsonProperty("recommendedConfidence")
    protected Integer recommendedConfidence;

    @JsonProperty("uniqueCount")
    protected Integer uniqueCount;

    protected DetectedSensitiveContentBase() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.detectedSensitiveContentBase";
    }

    @Property(name="confidence")
    @JsonIgnore
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(confidence);
    }

    public DetectedSensitiveContentBase withConfidence(Integer confidence) {
        DetectedSensitiveContentBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContentBase");
        _x.confidence = confidence;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public DetectedSensitiveContentBase withDisplayName(String displayName) {
        DetectedSensitiveContentBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContentBase");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<UUID> getId() {
        return Optional.ofNullable(id);
    }

    public DetectedSensitiveContentBase withId(UUID id) {
        DetectedSensitiveContentBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContentBase");
        _x.id = id;
        return _x;
    }

    @Property(name="recommendedConfidence")
    @JsonIgnore
    public Optional<Integer> getRecommendedConfidence() {
        return Optional.ofNullable(recommendedConfidence);
    }

    public DetectedSensitiveContentBase withRecommendedConfidence(Integer recommendedConfidence) {
        DetectedSensitiveContentBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContentBase");
        _x.recommendedConfidence = recommendedConfidence;
        return _x;
    }

    @Property(name="uniqueCount")
    @JsonIgnore
    public Optional<Integer> getUniqueCount() {
        return Optional.ofNullable(uniqueCount);
    }

    public DetectedSensitiveContentBase withUniqueCount(Integer uniqueCount) {
        DetectedSensitiveContentBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContentBase");
        _x.uniqueCount = uniqueCount;
        return _x;
    }

    public DetectedSensitiveContentBase withUnmappedField(String name, Object value) {
        DetectedSensitiveContentBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer confidence;
        private String displayName;
        private UUID id;
        private Integer recommendedConfidence;
        private Integer uniqueCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(UUID id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder recommendedConfidence(Integer recommendedConfidence) {
            this.recommendedConfidence = recommendedConfidence;
            this.changedFields = changedFields.add("recommendedConfidence");
            return this;
        }

        public Builder uniqueCount(Integer uniqueCount) {
            this.uniqueCount = uniqueCount;
            this.changedFields = changedFields.add("uniqueCount");
            return this;
        }

        public DetectedSensitiveContentBase build() {
            DetectedSensitiveContentBase _x = new DetectedSensitiveContentBase();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.detectedSensitiveContentBase";
            _x.confidence = confidence;
            _x.displayName = displayName;
            _x.id = id;
            _x.recommendedConfidence = recommendedConfidence;
            _x.uniqueCount = uniqueCount;
            return _x;
        }
    }

    private DetectedSensitiveContentBase _copy() {
        DetectedSensitiveContentBase _x = new DetectedSensitiveContentBase();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.confidence = confidence;
        _x.displayName = displayName;
        _x.id = id;
        _x.recommendedConfidence = recommendedConfidence;
        _x.uniqueCount = uniqueCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DetectedSensitiveContentBase[");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("recommendedConfidence=");
        b.append(this.recommendedConfidence);
        b.append(", ");
        b.append("uniqueCount=");
        b.append(this.uniqueCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
