package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeliveryOptimizationGroupIdOptionsType;


/**
 * <i>“Group id options type”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "groupIdSourceOption"})
@JsonInclude(Include.NON_NULL)
public class DeliveryOptimizationGroupIdSourceOptions extends DeliveryOptimizationGroupIdSource implements ODataType {

    @JsonProperty("groupIdSourceOption")
    protected DeliveryOptimizationGroupIdOptionsType groupIdSourceOption;

    protected DeliveryOptimizationGroupIdSourceOptions() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deliveryOptimizationGroupIdSourceOptions";
    }

    /**
     * <i>“Set this policy to restrict peer selection to a specific source.”</i>
     * 
     * @return property groupIdSourceOption
     */
    @Property(name="groupIdSourceOption")
    @JsonIgnore
    public Optional<DeliveryOptimizationGroupIdOptionsType> getGroupIdSourceOption() {
        return Optional.ofNullable(groupIdSourceOption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupIdSourceOption} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Set this policy to restrict peer selection to a specific source.”</i>
     * 
     * @param groupIdSourceOption
     *            new value of {@code groupIdSourceOption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupIdSourceOption} field changed
     */
    public DeliveryOptimizationGroupIdSourceOptions withGroupIdSourceOption(DeliveryOptimizationGroupIdOptionsType groupIdSourceOption) {
        DeliveryOptimizationGroupIdSourceOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationGroupIdSourceOptions");
        _x.groupIdSourceOption = groupIdSourceOption;
        return _x;
    }

    public DeliveryOptimizationGroupIdSourceOptions withUnmappedField(String name, Object value) {
        DeliveryOptimizationGroupIdSourceOptions _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeliveryOptimizationGroupIdSourceOptions() {
        return new Builder();
    }

    public static final class Builder {
        private DeliveryOptimizationGroupIdOptionsType groupIdSourceOption;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Set this policy to restrict peer selection to a specific source.”</i>
         * 
         * @param groupIdSourceOption
         *            value of {@code groupIdSourceOption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupIdSourceOption(DeliveryOptimizationGroupIdOptionsType groupIdSourceOption) {
            this.groupIdSourceOption = groupIdSourceOption;
            this.changedFields = changedFields.add("groupIdSourceOption");
            return this;
        }

        public DeliveryOptimizationGroupIdSourceOptions build() {
            DeliveryOptimizationGroupIdSourceOptions _x = new DeliveryOptimizationGroupIdSourceOptions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deliveryOptimizationGroupIdSourceOptions";
            _x.groupIdSourceOption = groupIdSourceOption;
            return _x;
        }
    }

    private DeliveryOptimizationGroupIdSourceOptions _copy() {
        DeliveryOptimizationGroupIdSourceOptions _x = new DeliveryOptimizationGroupIdSourceOptions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.groupIdSourceOption = groupIdSourceOption;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeliveryOptimizationGroupIdSourceOptions[");
        b.append("groupIdSourceOption=");
        b.append(this.groupIdSourceOption);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
