package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DefenderThreatAction;


/**
 * <i>“Specify Defender’s actions to take on detected Malware per threat level.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "highSeverity", 
    "lowSeverity", 
    "moderateSeverity", 
    "severeSeverity"})
@JsonInclude(Include.NON_NULL)
public class DefenderDetectedMalwareActions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("highSeverity")
    protected DefenderThreatAction highSeverity;

    @JsonProperty("lowSeverity")
    protected DefenderThreatAction lowSeverity;

    @JsonProperty("moderateSeverity")
    protected DefenderThreatAction moderateSeverity;

    @JsonProperty("severeSeverity")
    protected DefenderThreatAction severeSeverity;

    protected DefenderDetectedMalwareActions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.defenderDetectedMalwareActions";
    }

    /**
     * <i>“Indicates a Defender action to take for high severity Malware threat detected.”</i>
     * 
     * @return property highSeverity
     */
    @Property(name="highSeverity")
    @JsonIgnore
    public Optional<DefenderThreatAction> getHighSeverity() {
        return Optional.ofNullable(highSeverity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code highSeverity}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates a Defender action to take for high severity Malware threat detected.”</i>
     * 
     * @param highSeverity
     *            new value of {@code highSeverity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code highSeverity} field changed
     */
    public DefenderDetectedMalwareActions withHighSeverity(DefenderThreatAction highSeverity) {
        DefenderDetectedMalwareActions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defenderDetectedMalwareActions");
        _x.highSeverity = highSeverity;
        return _x;
    }

    /**
     * <i>“Indicates a Defender action to take for low severity Malware threat detected.”</i>
     * 
     * @return property lowSeverity
     */
    @Property(name="lowSeverity")
    @JsonIgnore
    public Optional<DefenderThreatAction> getLowSeverity() {
        return Optional.ofNullable(lowSeverity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lowSeverity}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates a Defender action to take for low severity Malware threat detected.”</i>
     * 
     * @param lowSeverity
     *            new value of {@code lowSeverity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lowSeverity} field changed
     */
    public DefenderDetectedMalwareActions withLowSeverity(DefenderThreatAction lowSeverity) {
        DefenderDetectedMalwareActions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defenderDetectedMalwareActions");
        _x.lowSeverity = lowSeverity;
        return _x;
    }

    /**
     * <i>“Indicates a Defender action to take for moderate severity Malware threat
     * detected.”</i>
     * 
     * @return property moderateSeverity
     */
    @Property(name="moderateSeverity")
    @JsonIgnore
    public Optional<DefenderThreatAction> getModerateSeverity() {
        return Optional.ofNullable(moderateSeverity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code moderateSeverity}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates a Defender action to take for moderate severity Malware threat
     * detected.”</i>
     * 
     * @param moderateSeverity
     *            new value of {@code moderateSeverity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code moderateSeverity} field changed
     */
    public DefenderDetectedMalwareActions withModerateSeverity(DefenderThreatAction moderateSeverity) {
        DefenderDetectedMalwareActions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defenderDetectedMalwareActions");
        _x.moderateSeverity = moderateSeverity;
        return _x;
    }

    /**
     * <i>“Indicates a Defender action to take for severe severity Malware threat detected.”</i>
     * 
     * @return property severeSeverity
     */
    @Property(name="severeSeverity")
    @JsonIgnore
    public Optional<DefenderThreatAction> getSevereSeverity() {
        return Optional.ofNullable(severeSeverity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code severeSeverity}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates a Defender action to take for severe severity Malware threat detected.”</i>
     * 
     * @param severeSeverity
     *            new value of {@code severeSeverity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code severeSeverity} field changed
     */
    public DefenderDetectedMalwareActions withSevereSeverity(DefenderThreatAction severeSeverity) {
        DefenderDetectedMalwareActions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defenderDetectedMalwareActions");
        _x.severeSeverity = severeSeverity;
        return _x;
    }

    public DefenderDetectedMalwareActions withUnmappedField(String name, Object value) {
        DefenderDetectedMalwareActions _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DefenderThreatAction highSeverity;
        private DefenderThreatAction lowSeverity;
        private DefenderThreatAction moderateSeverity;
        private DefenderThreatAction severeSeverity;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Indicates a Defender action to take for high severity Malware threat detected.”</i>
         * 
         * @param highSeverity
         *            value of {@code highSeverity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder highSeverity(DefenderThreatAction highSeverity) {
            this.highSeverity = highSeverity;
            this.changedFields = changedFields.add("highSeverity");
            return this;
        }

        /**
         * <i>“Indicates a Defender action to take for low severity Malware threat detected.”</i>
         * 
         * @param lowSeverity
         *            value of {@code lowSeverity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lowSeverity(DefenderThreatAction lowSeverity) {
            this.lowSeverity = lowSeverity;
            this.changedFields = changedFields.add("lowSeverity");
            return this;
        }

        /**
         * <i>“Indicates a Defender action to take for moderate severity Malware threat
         * detected.”</i>
         * 
         * @param moderateSeverity
         *            value of {@code moderateSeverity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder moderateSeverity(DefenderThreatAction moderateSeverity) {
            this.moderateSeverity = moderateSeverity;
            this.changedFields = changedFields.add("moderateSeverity");
            return this;
        }

        /**
         * <i>“Indicates a Defender action to take for severe severity Malware threat detected.”</i>
         * 
         * @param severeSeverity
         *            value of {@code severeSeverity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder severeSeverity(DefenderThreatAction severeSeverity) {
            this.severeSeverity = severeSeverity;
            this.changedFields = changedFields.add("severeSeverity");
            return this;
        }

        public DefenderDetectedMalwareActions build() {
            DefenderDetectedMalwareActions _x = new DefenderDetectedMalwareActions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.defenderDetectedMalwareActions";
            _x.highSeverity = highSeverity;
            _x.lowSeverity = lowSeverity;
            _x.moderateSeverity = moderateSeverity;
            _x.severeSeverity = severeSeverity;
            return _x;
        }
    }

    private DefenderDetectedMalwareActions _copy() {
        DefenderDetectedMalwareActions _x = new DefenderDetectedMalwareActions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.highSeverity = highSeverity;
        _x.lowSeverity = lowSeverity;
        _x.moderateSeverity = moderateSeverity;
        _x.severeSeverity = severeSeverity;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DefenderDetectedMalwareActions[");
        b.append("highSeverity=");
        b.append(this.highSeverity);
        b.append(", ");
        b.append("lowSeverity=");
        b.append(this.lowSeverity);
        b.append(", ");
        b.append("moderateSeverity=");
        b.append(this.moderateSeverity);
        b.append(", ");
        b.append("severeSeverity=");
        b.append(this.severeSeverity);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
