package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowedToCreateApps", 
    "allowedToCreateSecurityGroups", 
    "allowedToReadOtherUsers"})
@JsonInclude(Include.NON_NULL)
public class DefaultUserRolePermissions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowedToCreateApps")
    protected Boolean allowedToCreateApps;

    @JsonProperty("allowedToCreateSecurityGroups")
    protected Boolean allowedToCreateSecurityGroups;

    @JsonProperty("allowedToReadOtherUsers")
    protected Boolean allowedToReadOtherUsers;

    protected DefaultUserRolePermissions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.defaultUserRolePermissions";
    }

    @Property(name="allowedToCreateApps")
    @JsonIgnore
    public Optional<Boolean> getAllowedToCreateApps() {
        return Optional.ofNullable(allowedToCreateApps);
    }

    public DefaultUserRolePermissions withAllowedToCreateApps(Boolean allowedToCreateApps) {
        DefaultUserRolePermissions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultUserRolePermissions");
        _x.allowedToCreateApps = allowedToCreateApps;
        return _x;
    }

    @Property(name="allowedToCreateSecurityGroups")
    @JsonIgnore
    public Optional<Boolean> getAllowedToCreateSecurityGroups() {
        return Optional.ofNullable(allowedToCreateSecurityGroups);
    }

    public DefaultUserRolePermissions withAllowedToCreateSecurityGroups(Boolean allowedToCreateSecurityGroups) {
        DefaultUserRolePermissions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultUserRolePermissions");
        _x.allowedToCreateSecurityGroups = allowedToCreateSecurityGroups;
        return _x;
    }

    @Property(name="allowedToReadOtherUsers")
    @JsonIgnore
    public Optional<Boolean> getAllowedToReadOtherUsers() {
        return Optional.ofNullable(allowedToReadOtherUsers);
    }

    public DefaultUserRolePermissions withAllowedToReadOtherUsers(Boolean allowedToReadOtherUsers) {
        DefaultUserRolePermissions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultUserRolePermissions");
        _x.allowedToReadOtherUsers = allowedToReadOtherUsers;
        return _x;
    }

    public DefaultUserRolePermissions withUnmappedField(String name, Object value) {
        DefaultUserRolePermissions _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowedToCreateApps;
        private Boolean allowedToCreateSecurityGroups;
        private Boolean allowedToReadOtherUsers;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowedToCreateApps(Boolean allowedToCreateApps) {
            this.allowedToCreateApps = allowedToCreateApps;
            this.changedFields = changedFields.add("allowedToCreateApps");
            return this;
        }

        public Builder allowedToCreateSecurityGroups(Boolean allowedToCreateSecurityGroups) {
            this.allowedToCreateSecurityGroups = allowedToCreateSecurityGroups;
            this.changedFields = changedFields.add("allowedToCreateSecurityGroups");
            return this;
        }

        public Builder allowedToReadOtherUsers(Boolean allowedToReadOtherUsers) {
            this.allowedToReadOtherUsers = allowedToReadOtherUsers;
            this.changedFields = changedFields.add("allowedToReadOtherUsers");
            return this;
        }

        public DefaultUserRolePermissions build() {
            DefaultUserRolePermissions _x = new DefaultUserRolePermissions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.defaultUserRolePermissions";
            _x.allowedToCreateApps = allowedToCreateApps;
            _x.allowedToCreateSecurityGroups = allowedToCreateSecurityGroups;
            _x.allowedToReadOtherUsers = allowedToReadOtherUsers;
            return _x;
        }
    }

    private DefaultUserRolePermissions _copy() {
        DefaultUserRolePermissions _x = new DefaultUserRolePermissions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowedToCreateApps = allowedToCreateApps;
        _x.allowedToCreateSecurityGroups = allowedToCreateSecurityGroups;
        _x.allowedToReadOtherUsers = allowedToReadOtherUsers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DefaultUserRolePermissions[");
        b.append("allowedToCreateApps=");
        b.append(this.allowedToCreateApps);
        b.append(", ");
        b.append("allowedToCreateSecurityGroups=");
        b.append(this.allowedToCreateSecurityGroups);
        b.append(", ");
        b.append("allowedToReadOtherUsers=");
        b.append(this.allowedToReadOtherUsers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
