package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "questionId", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class CustomQuestionAnswer implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("questionId")
    protected String questionId;

    @JsonProperty("value")
    protected String value;

    protected CustomQuestionAnswer() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.customQuestionAnswer";
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CustomQuestionAnswer withDisplayName(String displayName) {
        CustomQuestionAnswer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customQuestionAnswer");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="questionId")
    @JsonIgnore
    public Optional<String> getQuestionId() {
        return Optional.ofNullable(questionId);
    }

    public CustomQuestionAnswer withQuestionId(String questionId) {
        CustomQuestionAnswer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customQuestionAnswer");
        _x.questionId = questionId;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public CustomQuestionAnswer withValue(String value) {
        CustomQuestionAnswer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customQuestionAnswer");
        _x.value = value;
        return _x;
    }

    public CustomQuestionAnswer withUnmappedField(String name, Object value) {
        CustomQuestionAnswer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String questionId;
        private String value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder questionId(String questionId) {
            this.questionId = questionId;
            this.changedFields = changedFields.add("questionId");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public CustomQuestionAnswer build() {
            CustomQuestionAnswer _x = new CustomQuestionAnswer();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.customQuestionAnswer";
            _x.displayName = displayName;
            _x.questionId = questionId;
            _x.value = value;
            return _x;
        }
    }

    private CustomQuestionAnswer _copy() {
        CustomQuestionAnswer _x = new CustomQuestionAnswer();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.questionId = questionId;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CustomQuestionAnswer[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("questionId=");
        b.append(this.questionId);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
