package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CrossTenantAccessPolicyTargetType;

@JsonPropertyOrder({
    "@odata.type", 
    "target", 
    "targetType"})
@JsonInclude(Include.NON_NULL)
public class CrossTenantAccessPolicyTarget implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("target")
    protected String target;

    @JsonProperty("targetType")
    protected CrossTenantAccessPolicyTargetType targetType;

    protected CrossTenantAccessPolicyTarget() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.crossTenantAccessPolicyTarget";
    }

    @Property(name="target")
    @JsonIgnore
    public Optional<String> getTarget() {
        return Optional.ofNullable(target);
    }

    public CrossTenantAccessPolicyTarget withTarget(String target) {
        CrossTenantAccessPolicyTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyTarget");
        _x.target = target;
        return _x;
    }

    @Property(name="targetType")
    @JsonIgnore
    public Optional<CrossTenantAccessPolicyTargetType> getTargetType() {
        return Optional.ofNullable(targetType);
    }

    public CrossTenantAccessPolicyTarget withTargetType(CrossTenantAccessPolicyTargetType targetType) {
        CrossTenantAccessPolicyTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyTarget");
        _x.targetType = targetType;
        return _x;
    }

    public CrossTenantAccessPolicyTarget withUnmappedField(String name, Object value) {
        CrossTenantAccessPolicyTarget _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String target;
        private CrossTenantAccessPolicyTargetType targetType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder target(String target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public Builder targetType(CrossTenantAccessPolicyTargetType targetType) {
            this.targetType = targetType;
            this.changedFields = changedFields.add("targetType");
            return this;
        }

        public CrossTenantAccessPolicyTarget build() {
            CrossTenantAccessPolicyTarget _x = new CrossTenantAccessPolicyTarget();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.crossTenantAccessPolicyTarget";
            _x.target = target;
            _x.targetType = targetType;
            return _x;
        }
    }

    private CrossTenantAccessPolicyTarget _copy() {
        CrossTenantAccessPolicyTarget _x = new CrossTenantAccessPolicyTarget();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.target = target;
        _x.targetType = targetType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CrossTenantAccessPolicyTarget[");
        b.append("target=");
        b.append(this.target);
        b.append(", ");
        b.append("targetType=");
        b.append(this.targetType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
