package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "applications", 
    "usersAndGroups"})
@JsonInclude(Include.NON_NULL)
public class CrossTenantAccessPolicyB2BSetting implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("applications")
    protected CrossTenantAccessPolicyTargetConfiguration applications;

    @JsonProperty("usersAndGroups")
    protected CrossTenantAccessPolicyTargetConfiguration usersAndGroups;

    protected CrossTenantAccessPolicyB2BSetting() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.crossTenantAccessPolicyB2BSetting";
    }

    @Property(name="applications")
    @JsonIgnore
    public Optional<CrossTenantAccessPolicyTargetConfiguration> getApplications() {
        return Optional.ofNullable(applications);
    }

    public CrossTenantAccessPolicyB2BSetting withApplications(CrossTenantAccessPolicyTargetConfiguration applications) {
        CrossTenantAccessPolicyB2BSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyB2BSetting");
        _x.applications = applications;
        return _x;
    }

    @Property(name="usersAndGroups")
    @JsonIgnore
    public Optional<CrossTenantAccessPolicyTargetConfiguration> getUsersAndGroups() {
        return Optional.ofNullable(usersAndGroups);
    }

    public CrossTenantAccessPolicyB2BSetting withUsersAndGroups(CrossTenantAccessPolicyTargetConfiguration usersAndGroups) {
        CrossTenantAccessPolicyB2BSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyB2BSetting");
        _x.usersAndGroups = usersAndGroups;
        return _x;
    }

    public CrossTenantAccessPolicyB2BSetting withUnmappedField(String name, Object value) {
        CrossTenantAccessPolicyB2BSetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CrossTenantAccessPolicyTargetConfiguration applications;
        private CrossTenantAccessPolicyTargetConfiguration usersAndGroups;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder applications(CrossTenantAccessPolicyTargetConfiguration applications) {
            this.applications = applications;
            this.changedFields = changedFields.add("applications");
            return this;
        }

        public Builder usersAndGroups(CrossTenantAccessPolicyTargetConfiguration usersAndGroups) {
            this.usersAndGroups = usersAndGroups;
            this.changedFields = changedFields.add("usersAndGroups");
            return this;
        }

        public CrossTenantAccessPolicyB2BSetting build() {
            CrossTenantAccessPolicyB2BSetting _x = new CrossTenantAccessPolicyB2BSetting();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.crossTenantAccessPolicyB2BSetting";
            _x.applications = applications;
            _x.usersAndGroups = usersAndGroups;
            return _x;
        }
    }

    private CrossTenantAccessPolicyB2BSetting _copy() {
        CrossTenantAccessPolicyB2BSetting _x = new CrossTenantAccessPolicyB2BSetting();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.applications = applications;
        _x.usersAndGroups = usersAndGroups;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CrossTenantAccessPolicyB2BSetting[");
        b.append("applications=");
        b.append(this.applications);
        b.append(", ");
        b.append("usersAndGroups=");
        b.append(this.usersAndGroups);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
