package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "confidence", 
    "matches", 
    "sensitiveTypeId", 
    "uniqueCount"})
@JsonInclude(Include.NON_NULL)
public class ContentClassification implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("confidence")
    protected Integer confidence;

    @JsonProperty("matches")
    protected List<MatchLocation> matches;

    @JsonProperty("matches@nextLink")
    protected String matchesNextLink;

    @JsonProperty("sensitiveTypeId")
    protected String sensitiveTypeId;

    @JsonProperty("uniqueCount")
    protected Integer uniqueCount;

    protected ContentClassification() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.contentClassification";
    }

    @Property(name="confidence")
    @JsonIgnore
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(confidence);
    }

    public ContentClassification withConfidence(Integer confidence) {
        ContentClassification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentClassification");
        _x.confidence = confidence;
        return _x;
    }

    @Property(name="matches")
    @JsonIgnore
    public CollectionPage<MatchLocation> getMatches() {
        return new CollectionPage<MatchLocation>(contextPath, MatchLocation.class, this.matches, Optional.ofNullable(matchesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="matches")
    @JsonIgnore
    public CollectionPage<MatchLocation> getMatches(HttpRequestOptions options) {
        return new CollectionPage<MatchLocation>(contextPath, MatchLocation.class, this.matches, Optional.ofNullable(matchesNextLink), Collections.emptyList(), options);
    }

    @Property(name="sensitiveTypeId")
    @JsonIgnore
    public Optional<String> getSensitiveTypeId() {
        return Optional.ofNullable(sensitiveTypeId);
    }

    public ContentClassification withSensitiveTypeId(String sensitiveTypeId) {
        ContentClassification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentClassification");
        _x.sensitiveTypeId = sensitiveTypeId;
        return _x;
    }

    @Property(name="uniqueCount")
    @JsonIgnore
    public Optional<Integer> getUniqueCount() {
        return Optional.ofNullable(uniqueCount);
    }

    public ContentClassification withUniqueCount(Integer uniqueCount) {
        ContentClassification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentClassification");
        _x.uniqueCount = uniqueCount;
        return _x;
    }

    public ContentClassification withUnmappedField(String name, Object value) {
        ContentClassification _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer confidence;
        private List<MatchLocation> matches;
        private String matchesNextLink;
        private String sensitiveTypeId;
        private Integer uniqueCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder matches(List<MatchLocation> matches) {
            this.matches = matches;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public Builder matches(MatchLocation... matches) {
            return matches(Arrays.asList(matches));
        }

        public Builder matchesNextLink(String matchesNextLink) {
            this.matchesNextLink = matchesNextLink;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public Builder sensitiveTypeId(String sensitiveTypeId) {
            this.sensitiveTypeId = sensitiveTypeId;
            this.changedFields = changedFields.add("sensitiveTypeId");
            return this;
        }

        public Builder uniqueCount(Integer uniqueCount) {
            this.uniqueCount = uniqueCount;
            this.changedFields = changedFields.add("uniqueCount");
            return this;
        }

        public ContentClassification build() {
            ContentClassification _x = new ContentClassification();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.contentClassification";
            _x.confidence = confidence;
            _x.matches = matches;
            _x.matchesNextLink = matchesNextLink;
            _x.sensitiveTypeId = sensitiveTypeId;
            _x.uniqueCount = uniqueCount;
            return _x;
        }
    }

    private ContentClassification _copy() {
        ContentClassification _x = new ContentClassification();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.confidence = confidence;
        _x.matches = matches;
        _x.sensitiveTypeId = sensitiveTypeId;
        _x.uniqueCount = uniqueCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContentClassification[");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("matches=");
        b.append(this.matches);
        b.append(", ");
        b.append("sensitiveTypeId=");
        b.append(this.sensitiveTypeId);
        b.append(", ");
        b.append("uniqueCount=");
        b.append(this.uniqueCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
