package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceAndAppManagementAssignmentFilterType;


/**
 * <i>“Represents an assignment to a Configuration Manager Collection.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "collectionId"})
@JsonInclude(Include.NON_NULL)
public class ConfigurationManagerCollectionAssignmentTarget extends DeviceAndAppManagementAssignmentTarget implements ODataType {

    @JsonProperty("collectionId")
    protected String collectionId;

    protected ConfigurationManagerCollectionAssignmentTarget() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.configurationManagerCollectionAssignmentTarget";
    }

    /**
     * <i>“The collection Id that is the target of the assignment.”</i>
     * 
     * @return property collectionId
     */
    @Property(name="collectionId")
    @JsonIgnore
    public Optional<String> getCollectionId() {
        return Optional.ofNullable(collectionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code collectionId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The collection Id that is the target of the assignment.”</i>
     * 
     * @param collectionId
     *            new value of {@code collectionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code collectionId} field changed
     */
    public ConfigurationManagerCollectionAssignmentTarget withCollectionId(String collectionId) {
        ConfigurationManagerCollectionAssignmentTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerCollectionAssignmentTarget");
        _x.collectionId = collectionId;
        return _x;
    }

    public ConfigurationManagerCollectionAssignmentTarget withUnmappedField(String name, Object value) {
        ConfigurationManagerCollectionAssignmentTarget _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConfigurationManagerCollectionAssignmentTarget() {
        return new Builder();
    }

    public static final class Builder {
        private String deviceAndAppManagementAssignmentFilterId;
        private DeviceAndAppManagementAssignmentFilterType deviceAndAppManagementAssignmentFilterType;
        private String collectionId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder deviceAndAppManagementAssignmentFilterId(String deviceAndAppManagementAssignmentFilterId) {
            this.deviceAndAppManagementAssignmentFilterId = deviceAndAppManagementAssignmentFilterId;
            this.changedFields = changedFields.add("deviceAndAppManagementAssignmentFilterId");
            return this;
        }

        public Builder deviceAndAppManagementAssignmentFilterType(DeviceAndAppManagementAssignmentFilterType deviceAndAppManagementAssignmentFilterType) {
            this.deviceAndAppManagementAssignmentFilterType = deviceAndAppManagementAssignmentFilterType;
            this.changedFields = changedFields.add("deviceAndAppManagementAssignmentFilterType");
            return this;
        }

        /**
         * <i>“The collection Id that is the target of the assignment.”</i>
         * 
         * @param collectionId
         *            value of {@code collectionId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            this.changedFields = changedFields.add("collectionId");
            return this;
        }

        public ConfigurationManagerCollectionAssignmentTarget build() {
            ConfigurationManagerCollectionAssignmentTarget _x = new ConfigurationManagerCollectionAssignmentTarget();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.configurationManagerCollectionAssignmentTarget";
            _x.deviceAndAppManagementAssignmentFilterId = deviceAndAppManagementAssignmentFilterId;
            _x.deviceAndAppManagementAssignmentFilterType = deviceAndAppManagementAssignmentFilterType;
            _x.collectionId = collectionId;
            return _x;
        }
    }

    private ConfigurationManagerCollectionAssignmentTarget _copy() {
        ConfigurationManagerCollectionAssignmentTarget _x = new ConfigurationManagerCollectionAssignmentTarget();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceAndAppManagementAssignmentFilterId = deviceAndAppManagementAssignmentFilterId;
        _x.deviceAndAppManagementAssignmentFilterType = deviceAndAppManagementAssignmentFilterType;
        _x.collectionId = collectionId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConfigurationManagerCollectionAssignmentTarget[");
        b.append("deviceAndAppManagementAssignmentFilterId=");
        b.append(this.deviceAndAppManagementAssignmentFilterId);
        b.append(", ");
        b.append("deviceAndAppManagementAssignmentFilterType=");
        b.append(this.deviceAndAppManagementAssignmentFilterType);
        b.append(", ");
        b.append("collectionId=");
        b.append(this.collectionId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
