package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Configuration Manager client information synced from SCCM”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "clientIdentifier", 
    "isBlocked"})
@JsonInclude(Include.NON_NULL)
public class ConfigurationManagerClientInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("clientIdentifier")
    protected String clientIdentifier;

    @JsonProperty("isBlocked")
    protected Boolean isBlocked;

    protected ConfigurationManagerClientInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.configurationManagerClientInformation";
    }

    /**
     * <i>“Configuration Manager Client Id from SCCM”</i>
     * 
     * @return property clientIdentifier
     */
    @Property(name="clientIdentifier")
    @JsonIgnore
    public Optional<String> getClientIdentifier() {
        return Optional.ofNullable(clientIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code clientIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Configuration Manager Client Id from SCCM”</i>
     * 
     * @param clientIdentifier
     *            new value of {@code clientIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code clientIdentifier} field changed
     */
    public ConfigurationManagerClientInformation withClientIdentifier(String clientIdentifier) {
        ConfigurationManagerClientInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerClientInformation");
        _x.clientIdentifier = clientIdentifier;
        return _x;
    }

    /**
     * <i>“Configuration Manager Client blocked status from SCCM”</i>
     * 
     * @return property isBlocked
     */
    @Property(name="isBlocked")
    @JsonIgnore
    public Optional<Boolean> getIsBlocked() {
        return Optional.ofNullable(isBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isBlocked} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Configuration Manager Client blocked status from SCCM”</i>
     * 
     * @param isBlocked
     *            new value of {@code isBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isBlocked} field changed
     */
    public ConfigurationManagerClientInformation withIsBlocked(Boolean isBlocked) {
        ConfigurationManagerClientInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerClientInformation");
        _x.isBlocked = isBlocked;
        return _x;
    }

    public ConfigurationManagerClientInformation withUnmappedField(String name, Object value) {
        ConfigurationManagerClientInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String clientIdentifier;
        private Boolean isBlocked;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Configuration Manager Client Id from SCCM”</i>
         * 
         * @param clientIdentifier
         *            value of {@code clientIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder clientIdentifier(String clientIdentifier) {
            this.clientIdentifier = clientIdentifier;
            this.changedFields = changedFields.add("clientIdentifier");
            return this;
        }

        /**
         * <i>“Configuration Manager Client blocked status from SCCM”</i>
         * 
         * @param isBlocked
         *            value of {@code isBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isBlocked(Boolean isBlocked) {
            this.isBlocked = isBlocked;
            this.changedFields = changedFields.add("isBlocked");
            return this;
        }

        public ConfigurationManagerClientInformation build() {
            ConfigurationManagerClientInformation _x = new ConfigurationManagerClientInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.configurationManagerClientInformation";
            _x.clientIdentifier = clientIdentifier;
            _x.isBlocked = isBlocked;
            return _x;
        }
    }

    private ConfigurationManagerClientInformation _copy() {
        ConfigurationManagerClientInformation _x = new ConfigurationManagerClientInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.clientIdentifier = clientIdentifier;
        _x.isBlocked = isBlocked;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConfigurationManagerClientInformation[");
        b.append("clientIdentifier=");
        b.append(this.clientIdentifier);
        b.append(", ");
        b.append("isBlocked=");
        b.append(this.isBlocked);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
