package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "authorizedAppIds", 
    "authorizedApps"})
@JsonInclude(Include.NON_NULL)
public class Configuration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("authorizedAppIds")
    protected List<String> authorizedAppIds;

    @JsonProperty("authorizedAppIds@nextLink")
    protected String authorizedAppIdsNextLink;

    @JsonProperty("authorizedApps")
    protected List<String> authorizedApps;

    @JsonProperty("authorizedApps@nextLink")
    protected String authorizedAppsNextLink;

    protected Configuration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.configuration";
    }

    @Property(name="authorizedAppIds")
    @JsonIgnore
    public CollectionPage<String> getAuthorizedAppIds() {
        return new CollectionPage<String>(contextPath, String.class, this.authorizedAppIds, Optional.ofNullable(authorizedAppIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="authorizedAppIds")
    @JsonIgnore
    public CollectionPage<String> getAuthorizedAppIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.authorizedAppIds, Optional.ofNullable(authorizedAppIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property authorizedApps
     */
    @Property(name="authorizedApps")
    @JsonIgnore
    public CollectionPage<String> getAuthorizedApps() {
        return new CollectionPage<String>(contextPath, String.class, this.authorizedApps, Optional.ofNullable(authorizedAppsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property authorizedApps
     */
    @Property(name="authorizedApps")
    @JsonIgnore
    public CollectionPage<String> getAuthorizedApps(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.authorizedApps, Optional.ofNullable(authorizedAppsNextLink), Collections.emptyList(), options);
    }

    public Configuration withUnmappedField(String name, Object value) {
        Configuration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> authorizedAppIds;
        private String authorizedAppIdsNextLink;
        private List<String> authorizedApps;
        private String authorizedAppsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder authorizedAppIds(List<String> authorizedAppIds) {
            this.authorizedAppIds = authorizedAppIds;
            this.changedFields = changedFields.add("authorizedAppIds");
            return this;
        }

        public Builder authorizedAppIds(String... authorizedAppIds) {
            return authorizedAppIds(Arrays.asList(authorizedAppIds));
        }

        public Builder authorizedAppIdsNextLink(String authorizedAppIdsNextLink) {
            this.authorizedAppIdsNextLink = authorizedAppIdsNextLink;
            this.changedFields = changedFields.add("authorizedAppIds");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param authorizedApps
         *            value of {@code authorizedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authorizedApps(List<String> authorizedApps) {
            this.authorizedApps = authorizedApps;
            this.changedFields = changedFields.add("authorizedApps");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param authorizedApps
         *            value of {@code authorizedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authorizedApps(String... authorizedApps) {
            return authorizedApps(Arrays.asList(authorizedApps));
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param authorizedAppsNextLink
         *            value of {@code authorizedApps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authorizedAppsNextLink(String authorizedAppsNextLink) {
            this.authorizedAppsNextLink = authorizedAppsNextLink;
            this.changedFields = changedFields.add("authorizedApps");
            return this;
        }

        public Configuration build() {
            Configuration _x = new Configuration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.configuration";
            _x.authorizedAppIds = authorizedAppIds;
            _x.authorizedAppIdsNextLink = authorizedAppIdsNextLink;
            _x.authorizedApps = authorizedApps;
            _x.authorizedAppsNextLink = authorizedAppsNextLink;
            return _x;
        }
    }

    private Configuration _copy() {
        Configuration _x = new Configuration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.authorizedAppIds = authorizedAppIds;
        _x.authorizedApps = authorizedApps;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Configuration[");
        b.append("authorizedAppIds=");
        b.append(this.authorizedAppIds);
        b.append(", ");
        b.append("authorizedApps=");
        b.append(this.authorizedApps);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
