package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ConditionalAccessConditions;
import odata.msgraph.client.beta.enums.ConditionalAccessRule;

@JsonPropertyOrder({
    "@odata.type", 
    "conditionalAccessCondition", 
    "ruleSatisfied"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessRuleSatisfied implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("conditionalAccessCondition")
    protected ConditionalAccessConditions conditionalAccessCondition;

    @JsonProperty("ruleSatisfied")
    protected ConditionalAccessRule ruleSatisfied;

    protected ConditionalAccessRuleSatisfied() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessRuleSatisfied";
    }

    @Property(name="conditionalAccessCondition")
    @JsonIgnore
    public Optional<ConditionalAccessConditions> getConditionalAccessCondition() {
        return Optional.ofNullable(conditionalAccessCondition);
    }

    public ConditionalAccessRuleSatisfied withConditionalAccessCondition(ConditionalAccessConditions conditionalAccessCondition) {
        ConditionalAccessRuleSatisfied _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessRuleSatisfied");
        _x.conditionalAccessCondition = conditionalAccessCondition;
        return _x;
    }

    @Property(name="ruleSatisfied")
    @JsonIgnore
    public Optional<ConditionalAccessRule> getRuleSatisfied() {
        return Optional.ofNullable(ruleSatisfied);
    }

    public ConditionalAccessRuleSatisfied withRuleSatisfied(ConditionalAccessRule ruleSatisfied) {
        ConditionalAccessRuleSatisfied _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessRuleSatisfied");
        _x.ruleSatisfied = ruleSatisfied;
        return _x;
    }

    public ConditionalAccessRuleSatisfied withUnmappedField(String name, Object value) {
        ConditionalAccessRuleSatisfied _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ConditionalAccessConditions conditionalAccessCondition;
        private ConditionalAccessRule ruleSatisfied;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder conditionalAccessCondition(ConditionalAccessConditions conditionalAccessCondition) {
            this.conditionalAccessCondition = conditionalAccessCondition;
            this.changedFields = changedFields.add("conditionalAccessCondition");
            return this;
        }

        public Builder ruleSatisfied(ConditionalAccessRule ruleSatisfied) {
            this.ruleSatisfied = ruleSatisfied;
            this.changedFields = changedFields.add("ruleSatisfied");
            return this;
        }

        public ConditionalAccessRuleSatisfied build() {
            ConditionalAccessRuleSatisfied _x = new ConditionalAccessRuleSatisfied();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.conditionalAccessRuleSatisfied";
            _x.conditionalAccessCondition = conditionalAccessCondition;
            _x.ruleSatisfied = ruleSatisfied;
            return _x;
        }
    }

    private ConditionalAccessRuleSatisfied _copy() {
        ConditionalAccessRuleSatisfied _x = new ConditionalAccessRuleSatisfied();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.conditionalAccessCondition = conditionalAccessCondition;
        _x.ruleSatisfied = ruleSatisfied;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessRuleSatisfied[");
        b.append("conditionalAccessCondition=");
        b.append(this.conditionalAccessCondition);
        b.append(", ");
        b.append("ruleSatisfied=");
        b.append(this.ruleSatisfied);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
