package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CompanyPortalAction;
import odata.msgraph.client.beta.enums.DevicePlatformType;
import odata.msgraph.client.beta.enums.OwnerType;


/**
 * <i>“Blocked actions on the company portal as per platform and device ownership types”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "action", 
    "ownerType", 
    "platform"})
@JsonInclude(Include.NON_NULL)
public class CompanyPortalBlockedAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("action")
    protected CompanyPortalAction action;

    @JsonProperty("ownerType")
    protected OwnerType ownerType;

    @JsonProperty("platform")
    protected DevicePlatformType platform;

    protected CompanyPortalBlockedAction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.companyPortalBlockedAction";
    }

    /**
     * <i>“Device Action”</i>
     * 
     * @return property action
     */
    @Property(name="action")
    @JsonIgnore
    public Optional<CompanyPortalAction> getAction() {
        return Optional.ofNullable(action);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code action} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device Action”</i>
     * 
     * @param action
     *            new value of {@code action} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code action} field changed
     */
    public CompanyPortalBlockedAction withAction(CompanyPortalAction action) {
        CompanyPortalBlockedAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyPortalBlockedAction");
        _x.action = action;
        return _x;
    }

    /**
     * <i>“Device ownership type”</i>
     * 
     * @return property ownerType
     */
    @Property(name="ownerType")
    @JsonIgnore
    public Optional<OwnerType> getOwnerType() {
        return Optional.ofNullable(ownerType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ownerType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device ownership type”</i>
     * 
     * @param ownerType
     *            new value of {@code ownerType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ownerType} field changed
     */
    public CompanyPortalBlockedAction withOwnerType(OwnerType ownerType) {
        CompanyPortalBlockedAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyPortalBlockedAction");
        _x.ownerType = ownerType;
        return _x;
    }

    /**
     * <i>“Device OS/Platform”</i>
     * 
     * @return property platform
     */
    @Property(name="platform")
    @JsonIgnore
    public Optional<DevicePlatformType> getPlatform() {
        return Optional.ofNullable(platform);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platform} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device OS/Platform”</i>
     * 
     * @param platform
     *            new value of {@code platform} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platform} field changed
     */
    public CompanyPortalBlockedAction withPlatform(DevicePlatformType platform) {
        CompanyPortalBlockedAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyPortalBlockedAction");
        _x.platform = platform;
        return _x;
    }

    public CompanyPortalBlockedAction withUnmappedField(String name, Object value) {
        CompanyPortalBlockedAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CompanyPortalAction action;
        private OwnerType ownerType;
        private DevicePlatformType platform;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Device Action”</i>
         * 
         * @param action
         *            value of {@code action} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder action(CompanyPortalAction action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        /**
         * <i>“Device ownership type”</i>
         * 
         * @param ownerType
         *            value of {@code ownerType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ownerType(OwnerType ownerType) {
            this.ownerType = ownerType;
            this.changedFields = changedFields.add("ownerType");
            return this;
        }

        /**
         * <i>“Device OS/Platform”</i>
         * 
         * @param platform
         *            value of {@code platform} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platform(DevicePlatformType platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        public CompanyPortalBlockedAction build() {
            CompanyPortalBlockedAction _x = new CompanyPortalBlockedAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.companyPortalBlockedAction";
            _x.action = action;
            _x.ownerType = ownerType;
            _x.platform = platform;
            return _x;
        }
    }

    private CompanyPortalBlockedAction _copy() {
        CompanyPortalBlockedAction _x = new CompanyPortalBlockedAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.action = action;
        _x.ownerType = ownerType;
        _x.platform = platform;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CompanyPortalBlockedAction[");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("ownerType=");
        b.append(this.ownerType);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
