package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "address", 
    "department", 
    "displayName", 
    "officeLocation", 
    "pronunciation", 
    "webUrl"})
@JsonInclude(Include.NON_NULL)
public class CompanyDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("address")
    protected PhysicalAddress address;

    @JsonProperty("department")
    protected String department;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("officeLocation")
    protected String officeLocation;

    @JsonProperty("pronunciation")
    protected String pronunciation;

    @JsonProperty("webUrl")
    protected String webUrl;

    protected CompanyDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.companyDetail";
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<PhysicalAddress> getAddress() {
        return Optional.ofNullable(address);
    }

    public CompanyDetail withAddress(PhysicalAddress address) {
        CompanyDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyDetail");
        _x.address = address;
        return _x;
    }

    @Property(name="department")
    @JsonIgnore
    public Optional<String> getDepartment() {
        return Optional.ofNullable(department);
    }

    public CompanyDetail withDepartment(String department) {
        CompanyDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyDetail");
        _x.department = department;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CompanyDetail withDisplayName(String displayName) {
        CompanyDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="officeLocation")
    @JsonIgnore
    public Optional<String> getOfficeLocation() {
        return Optional.ofNullable(officeLocation);
    }

    public CompanyDetail withOfficeLocation(String officeLocation) {
        CompanyDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyDetail");
        _x.officeLocation = officeLocation;
        return _x;
    }

    @Property(name="pronunciation")
    @JsonIgnore
    public Optional<String> getPronunciation() {
        return Optional.ofNullable(pronunciation);
    }

    public CompanyDetail withPronunciation(String pronunciation) {
        CompanyDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyDetail");
        _x.pronunciation = pronunciation;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public CompanyDetail withWebUrl(String webUrl) {
        CompanyDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyDetail");
        _x.webUrl = webUrl;
        return _x;
    }

    public CompanyDetail withUnmappedField(String name, Object value) {
        CompanyDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PhysicalAddress address;
        private String department;
        private String displayName;
        private String officeLocation;
        private String pronunciation;
        private String webUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder address(PhysicalAddress address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder department(String department) {
            this.department = department;
            this.changedFields = changedFields.add("department");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder officeLocation(String officeLocation) {
            this.officeLocation = officeLocation;
            this.changedFields = changedFields.add("officeLocation");
            return this;
        }

        public Builder pronunciation(String pronunciation) {
            this.pronunciation = pronunciation;
            this.changedFields = changedFields.add("pronunciation");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public CompanyDetail build() {
            CompanyDetail _x = new CompanyDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.companyDetail";
            _x.address = address;
            _x.department = department;
            _x.displayName = displayName;
            _x.officeLocation = officeLocation;
            _x.pronunciation = pronunciation;
            _x.webUrl = webUrl;
            return _x;
        }
    }

    private CompanyDetail _copy() {
        CompanyDetail _x = new CompanyDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.address = address;
        _x.department = department;
        _x.displayName = displayName;
        _x.officeLocation = officeLocation;
        _x.pronunciation = pronunciation;
        _x.webUrl = webUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CompanyDetail[");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("department=");
        b.append(this.department);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("officeLocation=");
        b.append(this.officeLocation);
        b.append(", ");
        b.append("pronunciation=");
        b.append(this.pronunciation);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
