package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "defaultLanguage", 
    "descriptions", 
    "formula"})
@JsonInclude(Include.NON_NULL)
public class ColumnValidation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("defaultLanguage")
    protected String defaultLanguage;

    @JsonProperty("descriptions")
    protected List<DisplayNameLocalization> descriptions;

    @JsonProperty("descriptions@nextLink")
    protected String descriptionsNextLink;

    @JsonProperty("formula")
    protected String formula;

    protected ColumnValidation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.columnValidation";
    }

    @Property(name="defaultLanguage")
    @JsonIgnore
    public Optional<String> getDefaultLanguage() {
        return Optional.ofNullable(defaultLanguage);
    }

    public ColumnValidation withDefaultLanguage(String defaultLanguage) {
        ColumnValidation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnValidation");
        _x.defaultLanguage = defaultLanguage;
        return _x;
    }

    @Property(name="descriptions")
    @JsonIgnore
    public CollectionPage<DisplayNameLocalization> getDescriptions() {
        return new CollectionPage<DisplayNameLocalization>(contextPath, DisplayNameLocalization.class, this.descriptions, Optional.ofNullable(descriptionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="descriptions")
    @JsonIgnore
    public CollectionPage<DisplayNameLocalization> getDescriptions(HttpRequestOptions options) {
        return new CollectionPage<DisplayNameLocalization>(contextPath, DisplayNameLocalization.class, this.descriptions, Optional.ofNullable(descriptionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="formula")
    @JsonIgnore
    public Optional<String> getFormula() {
        return Optional.ofNullable(formula);
    }

    public ColumnValidation withFormula(String formula) {
        ColumnValidation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.columnValidation");
        _x.formula = formula;
        return _x;
    }

    public ColumnValidation withUnmappedField(String name, Object value) {
        ColumnValidation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String defaultLanguage;
        private List<DisplayNameLocalization> descriptions;
        private String descriptionsNextLink;
        private String formula;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder defaultLanguage(String defaultLanguage) {
            this.defaultLanguage = defaultLanguage;
            this.changedFields = changedFields.add("defaultLanguage");
            return this;
        }

        public Builder descriptions(List<DisplayNameLocalization> descriptions) {
            this.descriptions = descriptions;
            this.changedFields = changedFields.add("descriptions");
            return this;
        }

        public Builder descriptions(DisplayNameLocalization... descriptions) {
            return descriptions(Arrays.asList(descriptions));
        }

        public Builder descriptionsNextLink(String descriptionsNextLink) {
            this.descriptionsNextLink = descriptionsNextLink;
            this.changedFields = changedFields.add("descriptions");
            return this;
        }

        public Builder formula(String formula) {
            this.formula = formula;
            this.changedFields = changedFields.add("formula");
            return this;
        }

        public ColumnValidation build() {
            ColumnValidation _x = new ColumnValidation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.columnValidation";
            _x.defaultLanguage = defaultLanguage;
            _x.descriptions = descriptions;
            _x.descriptionsNextLink = descriptionsNextLink;
            _x.formula = formula;
            return _x;
        }
    }

    private ColumnValidation _copy() {
        ColumnValidation _x = new ColumnValidation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.defaultLanguage = defaultLanguage;
        _x.descriptions = descriptions;
        _x.formula = formula;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ColumnValidation[");
        b.append("defaultLanguage=");
        b.append(this.defaultLanguage);
        b.append(", ");
        b.append("descriptions=");
        b.append(this.descriptions);
        b.append(", ");
        b.append("formula=");
        b.append(this.formula);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
