package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;

@JsonPropertyOrder({
    "@odata.type", 
    "actionName", 
    "actionState", 
    "cloudPcId", 
    "lastUpdatedDateTime", 
    "managedDeviceId", 
    "startDateTime", 
    "statusDetails"})
@JsonInclude(Include.NON_NULL)
public class CloudPcRemoteActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("actionName")
    protected String actionName;

    @JsonProperty("actionState")
    protected ActionState actionState;

    @JsonProperty("cloudPcId")
    protected String cloudPcId;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("statusDetails")
    protected CloudPcStatusDetails statusDetails;

    protected CloudPcRemoteActionResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcRemoteActionResult";
    }

    @Property(name="actionName")
    @JsonIgnore
    public Optional<String> getActionName() {
        return Optional.ofNullable(actionName);
    }

    public CloudPcRemoteActionResult withActionName(String actionName) {
        CloudPcRemoteActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcRemoteActionResult");
        _x.actionName = actionName;
        return _x;
    }

    @Property(name="actionState")
    @JsonIgnore
    public Optional<ActionState> getActionState() {
        return Optional.ofNullable(actionState);
    }

    public CloudPcRemoteActionResult withActionState(ActionState actionState) {
        CloudPcRemoteActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcRemoteActionResult");
        _x.actionState = actionState;
        return _x;
    }

    @Property(name="cloudPcId")
    @JsonIgnore
    public Optional<String> getCloudPcId() {
        return Optional.ofNullable(cloudPcId);
    }

    public CloudPcRemoteActionResult withCloudPcId(String cloudPcId) {
        CloudPcRemoteActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcRemoteActionResult");
        _x.cloudPcId = cloudPcId;
        return _x;
    }

    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    public CloudPcRemoteActionResult withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        CloudPcRemoteActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcRemoteActionResult");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    public CloudPcRemoteActionResult withManagedDeviceId(String managedDeviceId) {
        CloudPcRemoteActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcRemoteActionResult");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public CloudPcRemoteActionResult withStartDateTime(OffsetDateTime startDateTime) {
        CloudPcRemoteActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcRemoteActionResult");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="statusDetails")
    @JsonIgnore
    public Optional<CloudPcStatusDetails> getStatusDetails() {
        return Optional.ofNullable(statusDetails);
    }

    public CloudPcRemoteActionResult withStatusDetails(CloudPcStatusDetails statusDetails) {
        CloudPcRemoteActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcRemoteActionResult");
        _x.statusDetails = statusDetails;
        return _x;
    }

    public CloudPcRemoteActionResult withUnmappedField(String name, Object value) {
        CloudPcRemoteActionResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String actionName;
        private ActionState actionState;
        private String cloudPcId;
        private OffsetDateTime lastUpdatedDateTime;
        private String managedDeviceId;
        private OffsetDateTime startDateTime;
        private CloudPcStatusDetails statusDetails;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        public Builder cloudPcId(String cloudPcId) {
            this.cloudPcId = cloudPcId;
            this.changedFields = changedFields.add("cloudPcId");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder statusDetails(CloudPcStatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            this.changedFields = changedFields.add("statusDetails");
            return this;
        }

        public CloudPcRemoteActionResult build() {
            CloudPcRemoteActionResult _x = new CloudPcRemoteActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcRemoteActionResult";
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.cloudPcId = cloudPcId;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.managedDeviceId = managedDeviceId;
            _x.startDateTime = startDateTime;
            _x.statusDetails = statusDetails;
            return _x;
        }
    }

    private CloudPcRemoteActionResult _copy() {
        CloudPcRemoteActionResult _x = new CloudPcRemoteActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.cloudPcId = cloudPcId;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.managedDeviceId = managedDeviceId;
        _x.startDateTime = startDateTime;
        _x.statusDetails = statusDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcRemoteActionResult[");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("cloudPcId=");
        b.append(this.cloudPcId);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("statusDetails=");
        b.append(this.statusDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
