package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CloudPcDomainJoinType;

@JsonPropertyOrder({
    "@odata.type", 
    "onPremisesConnectionId", 
    "regionName", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class CloudPcDomainJoinConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("onPremisesConnectionId")
    protected String onPremisesConnectionId;

    @JsonProperty("regionName")
    protected String regionName;

    @JsonProperty("type")
    protected CloudPcDomainJoinType type;

    protected CloudPcDomainJoinConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcDomainJoinConfiguration";
    }

    @Property(name="onPremisesConnectionId")
    @JsonIgnore
    public Optional<String> getOnPremisesConnectionId() {
        return Optional.ofNullable(onPremisesConnectionId);
    }

    public CloudPcDomainJoinConfiguration withOnPremisesConnectionId(String onPremisesConnectionId) {
        CloudPcDomainJoinConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDomainJoinConfiguration");
        _x.onPremisesConnectionId = onPremisesConnectionId;
        return _x;
    }

    @Property(name="regionName")
    @JsonIgnore
    public Optional<String> getRegionName() {
        return Optional.ofNullable(regionName);
    }

    public CloudPcDomainJoinConfiguration withRegionName(String regionName) {
        CloudPcDomainJoinConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDomainJoinConfiguration");
        _x.regionName = regionName;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<CloudPcDomainJoinType> getType() {
        return Optional.ofNullable(type);
    }

    public CloudPcDomainJoinConfiguration withType(CloudPcDomainJoinType type) {
        CloudPcDomainJoinConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDomainJoinConfiguration");
        _x.type = type;
        return _x;
    }

    public CloudPcDomainJoinConfiguration withUnmappedField(String name, Object value) {
        CloudPcDomainJoinConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String onPremisesConnectionId;
        private String regionName;
        private CloudPcDomainJoinType type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder onPremisesConnectionId(String onPremisesConnectionId) {
            this.onPremisesConnectionId = onPremisesConnectionId;
            this.changedFields = changedFields.add("onPremisesConnectionId");
            return this;
        }

        public Builder regionName(String regionName) {
            this.regionName = regionName;
            this.changedFields = changedFields.add("regionName");
            return this;
        }

        public Builder type(CloudPcDomainJoinType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public CloudPcDomainJoinConfiguration build() {
            CloudPcDomainJoinConfiguration _x = new CloudPcDomainJoinConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcDomainJoinConfiguration";
            _x.onPremisesConnectionId = onPremisesConnectionId;
            _x.regionName = regionName;
            _x.type = type;
            return _x;
        }
    }

    private CloudPcDomainJoinConfiguration _copy() {
        CloudPcDomainJoinConfiguration _x = new CloudPcDomainJoinConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.onPremisesConnectionId = onPremisesConnectionId;
        _x.regionName = regionName;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcDomainJoinConfiguration[");
        b.append("onPremisesConnectionId=");
        b.append(this.onPremisesConnectionId);
        b.append(", ");
        b.append("regionName=");
        b.append(this.regionName);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
