package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "destinationServiceIp", 
    "destinationServiceName", 
    "riskScore"})
@JsonInclude(Include.NON_NULL)
public class CloudAppSecurityState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("destinationServiceIp")
    protected String destinationServiceIp;

    @JsonProperty("destinationServiceName")
    protected String destinationServiceName;

    @JsonProperty("riskScore")
    protected String riskScore;

    protected CloudAppSecurityState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudAppSecurityState";
    }

    @Property(name="destinationServiceIp")
    @JsonIgnore
    public Optional<String> getDestinationServiceIp() {
        return Optional.ofNullable(destinationServiceIp);
    }

    public CloudAppSecurityState withDestinationServiceIp(String destinationServiceIp) {
        CloudAppSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityState");
        _x.destinationServiceIp = destinationServiceIp;
        return _x;
    }

    @Property(name="destinationServiceName")
    @JsonIgnore
    public Optional<String> getDestinationServiceName() {
        return Optional.ofNullable(destinationServiceName);
    }

    public CloudAppSecurityState withDestinationServiceName(String destinationServiceName) {
        CloudAppSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityState");
        _x.destinationServiceName = destinationServiceName;
        return _x;
    }

    @Property(name="riskScore")
    @JsonIgnore
    public Optional<String> getRiskScore() {
        return Optional.ofNullable(riskScore);
    }

    public CloudAppSecurityState withRiskScore(String riskScore) {
        CloudAppSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecurityState");
        _x.riskScore = riskScore;
        return _x;
    }

    public CloudAppSecurityState withUnmappedField(String name, Object value) {
        CloudAppSecurityState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String destinationServiceIp;
        private String destinationServiceName;
        private String riskScore;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder destinationServiceIp(String destinationServiceIp) {
            this.destinationServiceIp = destinationServiceIp;
            this.changedFields = changedFields.add("destinationServiceIp");
            return this;
        }

        public Builder destinationServiceName(String destinationServiceName) {
            this.destinationServiceName = destinationServiceName;
            this.changedFields = changedFields.add("destinationServiceName");
            return this;
        }

        public Builder riskScore(String riskScore) {
            this.riskScore = riskScore;
            this.changedFields = changedFields.add("riskScore");
            return this;
        }

        public CloudAppSecurityState build() {
            CloudAppSecurityState _x = new CloudAppSecurityState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudAppSecurityState";
            _x.destinationServiceIp = destinationServiceIp;
            _x.destinationServiceName = destinationServiceName;
            _x.riskScore = riskScore;
            return _x;
        }
    }

    private CloudAppSecurityState _copy() {
        CloudAppSecurityState _x = new CloudAppSecurityState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.destinationServiceIp = destinationServiceIp;
        _x.destinationServiceName = destinationServiceName;
        _x.riskScore = riskScore;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudAppSecurityState[");
        b.append("destinationServiceIp=");
        b.append(this.destinationServiceIp);
        b.append(", ");
        b.append("destinationServiceName=");
        b.append(this.destinationServiceName);
        b.append(", ");
        b.append("riskScore=");
        b.append(this.riskScore);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
