package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "certificateList"})
@JsonInclude(Include.NON_NULL)
public class ClientCertificateAuthentication extends ApiAuthenticationConfigurationBase implements ODataType {

    @JsonProperty("certificateList")
    protected List<Pkcs12CertificateInformation> certificateList;

    @JsonProperty("certificateList@nextLink")
    protected String certificateListNextLink;

    protected ClientCertificateAuthentication() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.clientCertificateAuthentication";
    }

    @Property(name="certificateList")
    @JsonIgnore
    public CollectionPage<Pkcs12CertificateInformation> getCertificateList() {
        return new CollectionPage<Pkcs12CertificateInformation>(contextPath, Pkcs12CertificateInformation.class, this.certificateList, Optional.ofNullable(certificateListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="certificateList")
    @JsonIgnore
    public CollectionPage<Pkcs12CertificateInformation> getCertificateList(HttpRequestOptions options) {
        return new CollectionPage<Pkcs12CertificateInformation>(contextPath, Pkcs12CertificateInformation.class, this.certificateList, Optional.ofNullable(certificateListNextLink), Collections.emptyList(), options);
    }

    public ClientCertificateAuthentication withUnmappedField(String name, Object value) {
        ClientCertificateAuthentication _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderClientCertificateAuthentication() {
        return new Builder();
    }

    public static final class Builder {
        private List<Pkcs12CertificateInformation> certificateList;
        private String certificateListNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder certificateList(List<Pkcs12CertificateInformation> certificateList) {
            this.certificateList = certificateList;
            this.changedFields = changedFields.add("certificateList");
            return this;
        }

        public Builder certificateList(Pkcs12CertificateInformation... certificateList) {
            return certificateList(Arrays.asList(certificateList));
        }

        public Builder certificateListNextLink(String certificateListNextLink) {
            this.certificateListNextLink = certificateListNextLink;
            this.changedFields = changedFields.add("certificateList");
            return this;
        }

        public ClientCertificateAuthentication build() {
            ClientCertificateAuthentication _x = new ClientCertificateAuthentication();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.clientCertificateAuthentication";
            _x.certificateList = certificateList;
            _x.certificateListNextLink = certificateListNextLink;
            return _x;
        }
    }

    private ClientCertificateAuthentication _copy() {
        ClientCertificateAuthentication _x = new ClientCertificateAuthentication();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.certificateList = certificateList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClientCertificateAuthentication[");
        b.append("certificateList=");
        b.append(this.certificateList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
