package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "details"})
@JsonInclude(Include.NON_NULL)
public class ClassificationError extends ClassifcationErrorBase implements ODataType {

    @JsonProperty("details")
    protected List<ClassifcationErrorBase> details;

    @JsonProperty("details@nextLink")
    protected String detailsNextLink;

    protected ClassificationError() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.classificationError";
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<ClassifcationErrorBase> getDetails() {
        return new CollectionPage<ClassifcationErrorBase>(contextPath, ClassifcationErrorBase.class, this.details, Optional.ofNullable(detailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<ClassifcationErrorBase> getDetails(HttpRequestOptions options) {
        return new CollectionPage<ClassifcationErrorBase>(contextPath, ClassifcationErrorBase.class, this.details, Optional.ofNullable(detailsNextLink), Collections.emptyList(), options);
    }

    public ClassificationError withUnmappedField(String name, Object value) {
        ClassificationError _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderClassificationError() {
        return new Builder();
    }

    public static final class Builder {
        private String code;
        private ClassificationInnerError innerError;
        private String message;
        private String target;
        private List<ClassifcationErrorBase> details;
        private String detailsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder innerError(ClassificationInnerError innerError) {
            this.innerError = innerError;
            this.changedFields = changedFields.add("innerError");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public Builder details(List<ClassifcationErrorBase> details) {
            this.details = details;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder details(ClassifcationErrorBase... details) {
            return details(Arrays.asList(details));
        }

        public Builder detailsNextLink(String detailsNextLink) {
            this.detailsNextLink = detailsNextLink;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public ClassificationError build() {
            ClassificationError _x = new ClassificationError();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.classificationError";
            _x.code = code;
            _x.innerError = innerError;
            _x.message = message;
            _x.target = target;
            _x.details = details;
            _x.detailsNextLink = detailsNextLink;
            return _x;
        }
    }

    private ClassificationError _copy() {
        ClassificationError _x = new ClassificationError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.code = code;
        _x.innerError = innerError;
        _x.message = message;
        _x.target = target;
        _x.details = details;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClassificationError[");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("innerError=");
        b.append(this.innerError);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append(", ");
        b.append("details=");
        b.append(this.details);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
