package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "code", 
    "innerError", 
    "message", 
    "target"})
@JsonInclude(Include.NON_NULL)
public class ClassifcationErrorBase implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("code")
    protected String code;

    @JsonProperty("innerError")
    protected ClassificationInnerError innerError;

    @JsonProperty("message")
    protected String message;

    @JsonProperty("target")
    protected String target;

    protected ClassifcationErrorBase() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.classifcationErrorBase";
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public ClassifcationErrorBase withCode(String code) {
        ClassifcationErrorBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.classifcationErrorBase");
        _x.code = code;
        return _x;
    }

    @Property(name="innerError")
    @JsonIgnore
    public Optional<ClassificationInnerError> getInnerError() {
        return Optional.ofNullable(innerError);
    }

    public ClassifcationErrorBase withInnerError(ClassificationInnerError innerError) {
        ClassifcationErrorBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.classifcationErrorBase");
        _x.innerError = innerError;
        return _x;
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public ClassifcationErrorBase withMessage(String message) {
        ClassifcationErrorBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.classifcationErrorBase");
        _x.message = message;
        return _x;
    }

    @Property(name="target")
    @JsonIgnore
    public Optional<String> getTarget() {
        return Optional.ofNullable(target);
    }

    public ClassifcationErrorBase withTarget(String target) {
        ClassifcationErrorBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.classifcationErrorBase");
        _x.target = target;
        return _x;
    }

    public ClassifcationErrorBase withUnmappedField(String name, Object value) {
        ClassifcationErrorBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String code;
        private ClassificationInnerError innerError;
        private String message;
        private String target;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder innerError(ClassificationInnerError innerError) {
            this.innerError = innerError;
            this.changedFields = changedFields.add("innerError");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public ClassifcationErrorBase build() {
            ClassifcationErrorBase _x = new ClassifcationErrorBase();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.classifcationErrorBase";
            _x.code = code;
            _x.innerError = innerError;
            _x.message = message;
            _x.target = target;
            return _x;
        }
    }

    private ClassifcationErrorBase _copy() {
        ClassifcationErrorBase _x = new ClassifcationErrorBase();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.code = code;
        _x.innerError = innerError;
        _x.message = message;
        _x.target = target;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClassifcationErrorBase[");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("innerError=");
        b.append(this.innerError);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
