package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Represents a property of the ChromeOS device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "updatable", 
    "value", 
    "valueType"})
@JsonInclude(Include.NON_NULL)
public class ChromeOSDeviceProperty implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("updatable")
    protected Boolean updatable;

    @JsonProperty("value")
    protected String value;

    @JsonProperty("valueType")
    protected String valueType;

    protected ChromeOSDeviceProperty() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chromeOSDeviceProperty";
    }

    /**
     * <i>“Name of the property”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the property”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public ChromeOSDeviceProperty withName(String name) {
        ChromeOSDeviceProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chromeOSDeviceProperty");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Whether this property is updatable”</i>
     * 
     * @return property updatable
     */
    @Property(name="updatable")
    @JsonIgnore
    public Optional<Boolean> getUpdatable() {
        return Optional.ofNullable(updatable);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code updatable} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether this property is updatable”</i>
     * 
     * @param updatable
     *            new value of {@code updatable} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updatable} field changed
     */
    public ChromeOSDeviceProperty withUpdatable(Boolean updatable) {
        ChromeOSDeviceProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chromeOSDeviceProperty");
        _x.updatable = updatable;
        return _x;
    }

    /**
     * <i>“Value of the property”</i>
     * 
     * @return property value
     */
    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code value} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Value of the property”</i>
     * 
     * @param value
     *            new value of {@code value} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code value} field changed
     */
    public ChromeOSDeviceProperty withValue(String value) {
        ChromeOSDeviceProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chromeOSDeviceProperty");
        _x.value = value;
        return _x;
    }

    /**
     * <i>“Type of the value”</i>
     * 
     * @return property valueType
     */
    @Property(name="valueType")
    @JsonIgnore
    public Optional<String> getValueType() {
        return Optional.ofNullable(valueType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code valueType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Type of the value”</i>
     * 
     * @param valueType
     *            new value of {@code valueType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code valueType} field changed
     */
    public ChromeOSDeviceProperty withValueType(String valueType) {
        ChromeOSDeviceProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chromeOSDeviceProperty");
        _x.valueType = valueType;
        return _x;
    }

    public ChromeOSDeviceProperty withUnmappedField(String name, Object value) {
        ChromeOSDeviceProperty _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private Boolean updatable;
        private String value;
        private String valueType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Name of the property”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Whether this property is updatable”</i>
         * 
         * @param updatable
         *            value of {@code updatable} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updatable(Boolean updatable) {
            this.updatable = updatable;
            this.changedFields = changedFields.add("updatable");
            return this;
        }

        /**
         * <i>“Value of the property”</i>
         * 
         * @param value
         *            value of {@code value} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        /**
         * <i>“Type of the value”</i>
         * 
         * @param valueType
         *            value of {@code valueType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder valueType(String valueType) {
            this.valueType = valueType;
            this.changedFields = changedFields.add("valueType");
            return this;
        }

        public ChromeOSDeviceProperty build() {
            ChromeOSDeviceProperty _x = new ChromeOSDeviceProperty();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chromeOSDeviceProperty";
            _x.name = name;
            _x.updatable = updatable;
            _x.value = value;
            _x.valueType = valueType;
            return _x;
        }
    }

    private ChromeOSDeviceProperty _copy() {
        ChromeOSDeviceProperty _x = new ChromeOSDeviceProperty();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.updatable = updatable;
        _x.value = value;
        _x.valueType = valueType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChromeOSDeviceProperty[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("updatable=");
        b.append(this.updatable);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append(", ");
        b.append("valueType=");
        b.append(this.valueType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
