package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowTextEntry", 
    "choices", 
    "displayAs"})
@JsonInclude(Include.NON_NULL)
public class ChoiceColumn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowTextEntry")
    protected Boolean allowTextEntry;

    @JsonProperty("choices")
    protected List<String> choices;

    @JsonProperty("choices@nextLink")
    protected String choicesNextLink;

    @JsonProperty("displayAs")
    protected String displayAs;

    protected ChoiceColumn() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.choiceColumn";
    }

    @Property(name="allowTextEntry")
    @JsonIgnore
    public Optional<Boolean> getAllowTextEntry() {
        return Optional.ofNullable(allowTextEntry);
    }

    public ChoiceColumn withAllowTextEntry(Boolean allowTextEntry) {
        ChoiceColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.choiceColumn");
        _x.allowTextEntry = allowTextEntry;
        return _x;
    }

    @Property(name="choices")
    @JsonIgnore
    public CollectionPage<String> getChoices() {
        return new CollectionPage<String>(contextPath, String.class, this.choices, Optional.ofNullable(choicesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="choices")
    @JsonIgnore
    public CollectionPage<String> getChoices(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.choices, Optional.ofNullable(choicesNextLink), Collections.emptyList(), options);
    }

    @Property(name="displayAs")
    @JsonIgnore
    public Optional<String> getDisplayAs() {
        return Optional.ofNullable(displayAs);
    }

    public ChoiceColumn withDisplayAs(String displayAs) {
        ChoiceColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.choiceColumn");
        _x.displayAs = displayAs;
        return _x;
    }

    public ChoiceColumn withUnmappedField(String name, Object value) {
        ChoiceColumn _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowTextEntry;
        private List<String> choices;
        private String choicesNextLink;
        private String displayAs;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowTextEntry(Boolean allowTextEntry) {
            this.allowTextEntry = allowTextEntry;
            this.changedFields = changedFields.add("allowTextEntry");
            return this;
        }

        public Builder choices(List<String> choices) {
            this.choices = choices;
            this.changedFields = changedFields.add("choices");
            return this;
        }

        public Builder choices(String... choices) {
            return choices(Arrays.asList(choices));
        }

        public Builder choicesNextLink(String choicesNextLink) {
            this.choicesNextLink = choicesNextLink;
            this.changedFields = changedFields.add("choices");
            return this;
        }

        public Builder displayAs(String displayAs) {
            this.displayAs = displayAs;
            this.changedFields = changedFields.add("displayAs");
            return this;
        }

        public ChoiceColumn build() {
            ChoiceColumn _x = new ChoiceColumn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.choiceColumn";
            _x.allowTextEntry = allowTextEntry;
            _x.choices = choices;
            _x.choicesNextLink = choicesNextLink;
            _x.displayAs = displayAs;
            return _x;
        }
    }

    private ChoiceColumn _copy() {
        ChoiceColumn _x = new ChoiceColumn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowTextEntry = allowTextEntry;
        _x.choices = choices;
        _x.displayAs = displayAs;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChoiceColumn[");
        b.append("allowTextEntry=");
        b.append(this.allowTextEntry);
        b.append(", ");
        b.append("choices=");
        b.append(this.choices);
        b.append(", ");
        b.append("displayAs=");
        b.append(this.displayAs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
