package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isHidden", 
    "lastMessageReadDateTime"})
@JsonInclude(Include.NON_NULL)
public class ChatViewpoint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isHidden")
    protected Boolean isHidden;

    @JsonProperty("lastMessageReadDateTime")
    protected OffsetDateTime lastMessageReadDateTime;

    protected ChatViewpoint() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chatViewpoint";
    }

    @Property(name="isHidden")
    @JsonIgnore
    public Optional<Boolean> getIsHidden() {
        return Optional.ofNullable(isHidden);
    }

    public ChatViewpoint withIsHidden(Boolean isHidden) {
        ChatViewpoint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatViewpoint");
        _x.isHidden = isHidden;
        return _x;
    }

    @Property(name="lastMessageReadDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastMessageReadDateTime() {
        return Optional.ofNullable(lastMessageReadDateTime);
    }

    public ChatViewpoint withLastMessageReadDateTime(OffsetDateTime lastMessageReadDateTime) {
        ChatViewpoint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatViewpoint");
        _x.lastMessageReadDateTime = lastMessageReadDateTime;
        return _x;
    }

    public ChatViewpoint withUnmappedField(String name, Object value) {
        ChatViewpoint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isHidden;
        private OffsetDateTime lastMessageReadDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.changedFields = changedFields.add("isHidden");
            return this;
        }

        public Builder lastMessageReadDateTime(OffsetDateTime lastMessageReadDateTime) {
            this.lastMessageReadDateTime = lastMessageReadDateTime;
            this.changedFields = changedFields.add("lastMessageReadDateTime");
            return this;
        }

        public ChatViewpoint build() {
            ChatViewpoint _x = new ChatViewpoint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chatViewpoint";
            _x.isHidden = isHidden;
            _x.lastMessageReadDateTime = lastMessageReadDateTime;
            return _x;
        }
    }

    private ChatViewpoint _copy() {
        ChatViewpoint _x = new ChatViewpoint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isHidden = isHidden;
        _x.lastMessageReadDateTime = lastMessageReadDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChatViewpoint[");
        b.append("isHidden=");
        b.append(this.isHidden);
        b.append(", ");
        b.append("lastMessageReadDateTime=");
        b.append(this.lastMessageReadDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
