package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "reactionType", 
    "user"})
@JsonInclude(Include.NON_NULL)
public class ChatMessageReaction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("reactionType")
    protected String reactionType;

    @JsonProperty("user")
    protected ChatMessageReactionIdentitySet user;

    protected ChatMessageReaction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chatMessageReaction";
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ChatMessageReaction withCreatedDateTime(OffsetDateTime createdDateTime) {
        ChatMessageReaction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageReaction");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="reactionType")
    @JsonIgnore
    public Optional<String> getReactionType() {
        return Optional.ofNullable(reactionType);
    }

    public ChatMessageReaction withReactionType(String reactionType) {
        ChatMessageReaction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageReaction");
        _x.reactionType = reactionType;
        return _x;
    }

    @Property(name="user")
    @JsonIgnore
    public Optional<ChatMessageReactionIdentitySet> getUser() {
        return Optional.ofNullable(user);
    }

    public ChatMessageReaction withUser(ChatMessageReactionIdentitySet user) {
        ChatMessageReaction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageReaction");
        _x.user = user;
        return _x;
    }

    public ChatMessageReaction withUnmappedField(String name, Object value) {
        ChatMessageReaction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime createdDateTime;
        private String reactionType;
        private ChatMessageReactionIdentitySet user;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder reactionType(String reactionType) {
            this.reactionType = reactionType;
            this.changedFields = changedFields.add("reactionType");
            return this;
        }

        public Builder user(ChatMessageReactionIdentitySet user) {
            this.user = user;
            this.changedFields = changedFields.add("user");
            return this;
        }

        public ChatMessageReaction build() {
            ChatMessageReaction _x = new ChatMessageReaction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chatMessageReaction";
            _x.createdDateTime = createdDateTime;
            _x.reactionType = reactionType;
            _x.user = user;
            return _x;
        }
    }

    private ChatMessageReaction _copy() {
        ChatMessageReaction _x = new ChatMessageReaction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.createdDateTime = createdDateTime;
        _x.reactionType = reactionType;
        _x.user = user;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChatMessageReaction[");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("reactionType=");
        b.append(this.reactionType);
        b.append(", ");
        b.append("user=");
        b.append(this.user);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
