package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "content", 
    "contentType", 
    "contentUrl", 
    "id", 
    "name", 
    "thumbnailUrl"})
@JsonInclude(Include.NON_NULL)
public class ChatMessageAttachment implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("content")
    protected String content;

    @JsonProperty("contentType")
    protected String contentType;

    @JsonProperty("contentUrl")
    protected String contentUrl;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("thumbnailUrl")
    protected String thumbnailUrl;

    protected ChatMessageAttachment() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chatMessageAttachment";
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    public ChatMessageAttachment withContent(String content) {
        ChatMessageAttachment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageAttachment");
        _x.content = content;
        return _x;
    }

    @Property(name="contentType")
    @JsonIgnore
    public Optional<String> getContentType() {
        return Optional.ofNullable(contentType);
    }

    public ChatMessageAttachment withContentType(String contentType) {
        ChatMessageAttachment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageAttachment");
        _x.contentType = contentType;
        return _x;
    }

    @Property(name="contentUrl")
    @JsonIgnore
    public Optional<String> getContentUrl() {
        return Optional.ofNullable(contentUrl);
    }

    public ChatMessageAttachment withContentUrl(String contentUrl) {
        ChatMessageAttachment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageAttachment");
        _x.contentUrl = contentUrl;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public ChatMessageAttachment withId(String id) {
        ChatMessageAttachment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageAttachment");
        _x.id = id;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ChatMessageAttachment withName(String name) {
        ChatMessageAttachment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageAttachment");
        _x.name = name;
        return _x;
    }

    @Property(name="thumbnailUrl")
    @JsonIgnore
    public Optional<String> getThumbnailUrl() {
        return Optional.ofNullable(thumbnailUrl);
    }

    public ChatMessageAttachment withThumbnailUrl(String thumbnailUrl) {
        ChatMessageAttachment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageAttachment");
        _x.thumbnailUrl = thumbnailUrl;
        return _x;
    }

    public ChatMessageAttachment withUnmappedField(String name, Object value) {
        ChatMessageAttachment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String content;
        private String contentType;
        private String contentUrl;
        private String id;
        private String name;
        private String thumbnailUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            this.changedFields = changedFields.add("contentUrl");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            this.changedFields = changedFields.add("thumbnailUrl");
            return this;
        }

        public ChatMessageAttachment build() {
            ChatMessageAttachment _x = new ChatMessageAttachment();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chatMessageAttachment";
            _x.content = content;
            _x.contentType = contentType;
            _x.contentUrl = contentUrl;
            _x.id = id;
            _x.name = name;
            _x.thumbnailUrl = thumbnailUrl;
            return _x;
        }
    }

    private ChatMessageAttachment _copy() {
        ChatMessageAttachment _x = new ChatMessageAttachment();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.content = content;
        _x.contentType = contentType;
        _x.contentUrl = contentUrl;
        _x.id = id;
        _x.name = name;
        _x.thumbnailUrl = thumbnailUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChatMessageAttachment[");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("contentUrl=");
        b.append(this.contentUrl);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("thumbnailUrl=");
        b.append(this.thumbnailUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
