package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "channelId", 
    "teamId"})
@JsonInclude(Include.NON_NULL)
public class ChannelIdentity implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("channelId")
    protected String channelId;

    @JsonProperty("teamId")
    protected String teamId;

    protected ChannelIdentity() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.channelIdentity";
    }

    @Property(name="channelId")
    @JsonIgnore
    public Optional<String> getChannelId() {
        return Optional.ofNullable(channelId);
    }

    public ChannelIdentity withChannelId(String channelId) {
        ChannelIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channelIdentity");
        _x.channelId = channelId;
        return _x;
    }

    @Property(name="teamId")
    @JsonIgnore
    public Optional<String> getTeamId() {
        return Optional.ofNullable(teamId);
    }

    public ChannelIdentity withTeamId(String teamId) {
        ChannelIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channelIdentity");
        _x.teamId = teamId;
        return _x;
    }

    public ChannelIdentity withUnmappedField(String name, Object value) {
        ChannelIdentity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String channelId;
        private String teamId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder channelId(String channelId) {
            this.channelId = channelId;
            this.changedFields = changedFields.add("channelId");
            return this;
        }

        public Builder teamId(String teamId) {
            this.teamId = teamId;
            this.changedFields = changedFields.add("teamId");
            return this;
        }

        public ChannelIdentity build() {
            ChannelIdentity _x = new ChannelIdentity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.channelIdentity";
            _x.channelId = channelId;
            _x.teamId = teamId;
            return _x;
        }
    }

    private ChannelIdentity _copy() {
        ChannelIdentity _x = new ChannelIdentity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.channelId = channelId;
        _x.teamId = teamId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChannelIdentity[");
        b.append("channelId=");
        b.append(this.channelId);
        b.append(", ");
        b.append("teamId=");
        b.append(this.teamId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
