package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "certificationDetailsUrl", 
    "certificationExpirationDateTime", 
    "isCertifiedByMicrosoft", 
    "isPublisherAttested", 
    "lastCertificationDateTime"})
@JsonInclude(Include.NON_NULL)
public class Certification implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("certificationDetailsUrl")
    protected String certificationDetailsUrl;

    @JsonProperty("certificationExpirationDateTime")
    protected OffsetDateTime certificationExpirationDateTime;

    @JsonProperty("isCertifiedByMicrosoft")
    protected Boolean isCertifiedByMicrosoft;

    @JsonProperty("isPublisherAttested")
    protected Boolean isPublisherAttested;

    @JsonProperty("lastCertificationDateTime")
    protected OffsetDateTime lastCertificationDateTime;

    protected Certification() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.certification";
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property certificationDetailsUrl
     */
    @Property(name="certificationDetailsUrl")
    @JsonIgnore
    public Optional<String> getCertificationDetailsUrl() {
        return Optional.ofNullable(certificationDetailsUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificationDetailsUrl} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param certificationDetailsUrl
     *            new value of {@code certificationDetailsUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificationDetailsUrl} field changed
     */
    public Certification withCertificationDetailsUrl(String certificationDetailsUrl) {
        Certification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certification");
        _x.certificationDetailsUrl = certificationDetailsUrl;
        return _x;
    }

    @Property(name="certificationExpirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCertificationExpirationDateTime() {
        return Optional.ofNullable(certificationExpirationDateTime);
    }

    public Certification withCertificationExpirationDateTime(OffsetDateTime certificationExpirationDateTime) {
        Certification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certification");
        _x.certificationExpirationDateTime = certificationExpirationDateTime;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property isCertifiedByMicrosoft
     */
    @Property(name="isCertifiedByMicrosoft")
    @JsonIgnore
    public Optional<Boolean> getIsCertifiedByMicrosoft() {
        return Optional.ofNullable(isCertifiedByMicrosoft);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * isCertifiedByMicrosoft} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param isCertifiedByMicrosoft
     *            new value of {@code isCertifiedByMicrosoft} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isCertifiedByMicrosoft} field changed
     */
    public Certification withIsCertifiedByMicrosoft(Boolean isCertifiedByMicrosoft) {
        Certification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certification");
        _x.isCertifiedByMicrosoft = isCertifiedByMicrosoft;
        return _x;
    }

    @Property(name="isPublisherAttested")
    @JsonIgnore
    public Optional<Boolean> getIsPublisherAttested() {
        return Optional.ofNullable(isPublisherAttested);
    }

    public Certification withIsPublisherAttested(Boolean isPublisherAttested) {
        Certification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certification");
        _x.isPublisherAttested = isPublisherAttested;
        return _x;
    }

    @Property(name="lastCertificationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastCertificationDateTime() {
        return Optional.ofNullable(lastCertificationDateTime);
    }

    public Certification withLastCertificationDateTime(OffsetDateTime lastCertificationDateTime) {
        Certification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certification");
        _x.lastCertificationDateTime = lastCertificationDateTime;
        return _x;
    }

    public Certification withUnmappedField(String name, Object value) {
        Certification _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String certificationDetailsUrl;
        private OffsetDateTime certificationExpirationDateTime;
        private Boolean isCertifiedByMicrosoft;
        private Boolean isPublisherAttested;
        private OffsetDateTime lastCertificationDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param certificationDetailsUrl
         *            value of {@code certificationDetailsUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificationDetailsUrl(String certificationDetailsUrl) {
            this.certificationDetailsUrl = certificationDetailsUrl;
            this.changedFields = changedFields.add("certificationDetailsUrl");
            return this;
        }

        public Builder certificationExpirationDateTime(OffsetDateTime certificationExpirationDateTime) {
            this.certificationExpirationDateTime = certificationExpirationDateTime;
            this.changedFields = changedFields.add("certificationExpirationDateTime");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param isCertifiedByMicrosoft
         *            value of {@code isCertifiedByMicrosoft} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isCertifiedByMicrosoft(Boolean isCertifiedByMicrosoft) {
            this.isCertifiedByMicrosoft = isCertifiedByMicrosoft;
            this.changedFields = changedFields.add("isCertifiedByMicrosoft");
            return this;
        }

        public Builder isPublisherAttested(Boolean isPublisherAttested) {
            this.isPublisherAttested = isPublisherAttested;
            this.changedFields = changedFields.add("isPublisherAttested");
            return this;
        }

        public Builder lastCertificationDateTime(OffsetDateTime lastCertificationDateTime) {
            this.lastCertificationDateTime = lastCertificationDateTime;
            this.changedFields = changedFields.add("lastCertificationDateTime");
            return this;
        }

        public Certification build() {
            Certification _x = new Certification();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.certification";
            _x.certificationDetailsUrl = certificationDetailsUrl;
            _x.certificationExpirationDateTime = certificationExpirationDateTime;
            _x.isCertifiedByMicrosoft = isCertifiedByMicrosoft;
            _x.isPublisherAttested = isPublisherAttested;
            _x.lastCertificationDateTime = lastCertificationDateTime;
            return _x;
        }
    }

    private Certification _copy() {
        Certification _x = new Certification();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.certificationDetailsUrl = certificationDetailsUrl;
        _x.certificationExpirationDateTime = certificationExpirationDateTime;
        _x.isCertifiedByMicrosoft = isCertifiedByMicrosoft;
        _x.isPublisherAttested = isPublisherAttested;
        _x.lastCertificationDateTime = lastCertificationDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Certification[");
        b.append("certificationDetailsUrl=");
        b.append(this.certificationDetailsUrl);
        b.append(", ");
        b.append("certificationExpirationDateTime=");
        b.append(this.certificationExpirationDateTime);
        b.append(", ");
        b.append("isCertifiedByMicrosoft=");
        b.append(this.isCertifiedByMicrosoft);
        b.append(", ");
        b.append("isPublisherAttested=");
        b.append(this.isPublisherAttested);
        b.append(", ");
        b.append("lastCertificationDateTime=");
        b.append(this.lastCertificationDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
