package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Metric snapshot value returned in response to a GetHealthMetricTimeSeries
 * request.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "dateTime", 
    "failureCount", 
    "successCount"})
@JsonInclude(Include.NON_NULL)
public class CertificateConnectorHealthMetricValue implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dateTime")
    protected OffsetDateTime dateTime;

    @JsonProperty("failureCount")
    protected Long failureCount;

    @JsonProperty("successCount")
    protected Long successCount;

    protected CertificateConnectorHealthMetricValue() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.certificateConnectorHealthMetricValue";
    }

    /**
     * <i>“Timestamp for this metric data-point.”</i>
     * 
     * @return property dateTime
     */
    @Property(name="dateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDateTime() {
        return Optional.ofNullable(dateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dateTime} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Timestamp for this metric data-point.”</i>
     * 
     * @param dateTime
     *            new value of {@code dateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dateTime} field changed
     */
    public CertificateConnectorHealthMetricValue withDateTime(OffsetDateTime dateTime) {
        CertificateConnectorHealthMetricValue _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorHealthMetricValue");
        _x.dateTime = dateTime;
        return _x;
    }

    /**
     * <i>“Count of failed requests/operations.”</i>
     * 
     * @return property failureCount
     */
    @Property(name="failureCount")
    @JsonIgnore
    public Optional<Long> getFailureCount() {
        return Optional.ofNullable(failureCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failureCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of failed requests/operations.”</i>
     * 
     * @param failureCount
     *            new value of {@code failureCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failureCount} field changed
     */
    public CertificateConnectorHealthMetricValue withFailureCount(Long failureCount) {
        CertificateConnectorHealthMetricValue _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorHealthMetricValue");
        _x.failureCount = failureCount;
        return _x;
    }

    /**
     * <i>“Count of successful requests/operations.”</i>
     * 
     * @return property successCount
     */
    @Property(name="successCount")
    @JsonIgnore
    public Optional<Long> getSuccessCount() {
        return Optional.ofNullable(successCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code successCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of successful requests/operations.”</i>
     * 
     * @param successCount
     *            new value of {@code successCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code successCount} field changed
     */
    public CertificateConnectorHealthMetricValue withSuccessCount(Long successCount) {
        CertificateConnectorHealthMetricValue _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorHealthMetricValue");
        _x.successCount = successCount;
        return _x;
    }

    public CertificateConnectorHealthMetricValue withUnmappedField(String name, Object value) {
        CertificateConnectorHealthMetricValue _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime dateTime;
        private Long failureCount;
        private Long successCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Timestamp for this metric data-point.”</i>
         * 
         * @param dateTime
         *            value of {@code dateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dateTime(OffsetDateTime dateTime) {
            this.dateTime = dateTime;
            this.changedFields = changedFields.add("dateTime");
            return this;
        }

        /**
         * <i>“Count of failed requests/operations.”</i>
         * 
         * @param failureCount
         *            value of {@code failureCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failureCount(Long failureCount) {
            this.failureCount = failureCount;
            this.changedFields = changedFields.add("failureCount");
            return this;
        }

        /**
         * <i>“Count of successful requests/operations.”</i>
         * 
         * @param successCount
         *            value of {@code successCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successCount(Long successCount) {
            this.successCount = successCount;
            this.changedFields = changedFields.add("successCount");
            return this;
        }

        public CertificateConnectorHealthMetricValue build() {
            CertificateConnectorHealthMetricValue _x = new CertificateConnectorHealthMetricValue();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.certificateConnectorHealthMetricValue";
            _x.dateTime = dateTime;
            _x.failureCount = failureCount;
            _x.successCount = successCount;
            return _x;
        }
    }

    private CertificateConnectorHealthMetricValue _copy() {
        CertificateConnectorHealthMetricValue _x = new CertificateConnectorHealthMetricValue();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dateTime = dateTime;
        _x.failureCount = failureCount;
        _x.successCount = successCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CertificateConnectorHealthMetricValue[");
        b.append("dateTime=");
        b.append(this.dateTime);
        b.append(", ");
        b.append("failureCount=");
        b.append(this.failureCount);
        b.append(", ");
        b.append("successCount=");
        b.append(this.successCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
