package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "certificate", 
    "certificateRevocationListUrl", 
    "deltaCertificateRevocationListUrl", 
    "isRootAuthority", 
    "issuer", 
    "issuerSki"})
@JsonInclude(Include.NON_NULL)
public class CertificateAuthority implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("certificate")
    protected byte[] certificate;

    @JsonProperty("certificateRevocationListUrl")
    protected String certificateRevocationListUrl;

    @JsonProperty("deltaCertificateRevocationListUrl")
    protected String deltaCertificateRevocationListUrl;

    @JsonProperty("isRootAuthority")
    protected Boolean isRootAuthority;

    @JsonProperty("issuer")
    protected String issuer;

    @JsonProperty("issuerSki")
    protected String issuerSki;

    protected CertificateAuthority() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.certificateAuthority";
    }

    @Property(name="certificate")
    @JsonIgnore
    public Optional<byte[]> getCertificate() {
        return Optional.ofNullable(certificate);
    }

    public CertificateAuthority withCertificate(byte[] certificate) {
        CertificateAuthority _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateAuthority");
        _x.certificate = certificate;
        return _x;
    }

    @Property(name="certificateRevocationListUrl")
    @JsonIgnore
    public Optional<String> getCertificateRevocationListUrl() {
        return Optional.ofNullable(certificateRevocationListUrl);
    }

    public CertificateAuthority withCertificateRevocationListUrl(String certificateRevocationListUrl) {
        CertificateAuthority _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateAuthority");
        _x.certificateRevocationListUrl = certificateRevocationListUrl;
        return _x;
    }

    @Property(name="deltaCertificateRevocationListUrl")
    @JsonIgnore
    public Optional<String> getDeltaCertificateRevocationListUrl() {
        return Optional.ofNullable(deltaCertificateRevocationListUrl);
    }

    public CertificateAuthority withDeltaCertificateRevocationListUrl(String deltaCertificateRevocationListUrl) {
        CertificateAuthority _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateAuthority");
        _x.deltaCertificateRevocationListUrl = deltaCertificateRevocationListUrl;
        return _x;
    }

    @Property(name="isRootAuthority")
    @JsonIgnore
    public Optional<Boolean> getIsRootAuthority() {
        return Optional.ofNullable(isRootAuthority);
    }

    public CertificateAuthority withIsRootAuthority(Boolean isRootAuthority) {
        CertificateAuthority _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateAuthority");
        _x.isRootAuthority = isRootAuthority;
        return _x;
    }

    @Property(name="issuer")
    @JsonIgnore
    public Optional<String> getIssuer() {
        return Optional.ofNullable(issuer);
    }

    public CertificateAuthority withIssuer(String issuer) {
        CertificateAuthority _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateAuthority");
        _x.issuer = issuer;
        return _x;
    }

    @Property(name="issuerSki")
    @JsonIgnore
    public Optional<String> getIssuerSki() {
        return Optional.ofNullable(issuerSki);
    }

    public CertificateAuthority withIssuerSki(String issuerSki) {
        CertificateAuthority _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateAuthority");
        _x.issuerSki = issuerSki;
        return _x;
    }

    public CertificateAuthority withUnmappedField(String name, Object value) {
        CertificateAuthority _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private byte[] certificate;
        private String certificateRevocationListUrl;
        private String deltaCertificateRevocationListUrl;
        private Boolean isRootAuthority;
        private String issuer;
        private String issuerSki;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder certificate(byte[] certificate) {
            this.certificate = certificate;
            this.changedFields = changedFields.add("certificate");
            return this;
        }

        public Builder certificateRevocationListUrl(String certificateRevocationListUrl) {
            this.certificateRevocationListUrl = certificateRevocationListUrl;
            this.changedFields = changedFields.add("certificateRevocationListUrl");
            return this;
        }

        public Builder deltaCertificateRevocationListUrl(String deltaCertificateRevocationListUrl) {
            this.deltaCertificateRevocationListUrl = deltaCertificateRevocationListUrl;
            this.changedFields = changedFields.add("deltaCertificateRevocationListUrl");
            return this;
        }

        public Builder isRootAuthority(Boolean isRootAuthority) {
            this.isRootAuthority = isRootAuthority;
            this.changedFields = changedFields.add("isRootAuthority");
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            this.changedFields = changedFields.add("issuer");
            return this;
        }

        public Builder issuerSki(String issuerSki) {
            this.issuerSki = issuerSki;
            this.changedFields = changedFields.add("issuerSki");
            return this;
        }

        public CertificateAuthority build() {
            CertificateAuthority _x = new CertificateAuthority();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.certificateAuthority";
            _x.certificate = certificate;
            _x.certificateRevocationListUrl = certificateRevocationListUrl;
            _x.deltaCertificateRevocationListUrl = deltaCertificateRevocationListUrl;
            _x.isRootAuthority = isRootAuthority;
            _x.issuer = issuer;
            _x.issuerSki = issuerSki;
            return _x;
        }
    }

    private CertificateAuthority _copy() {
        CertificateAuthority _x = new CertificateAuthority();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.certificate = certificate;
        _x.certificateRevocationListUrl = certificateRevocationListUrl;
        _x.deltaCertificateRevocationListUrl = deltaCertificateRevocationListUrl;
        _x.isRootAuthority = isRootAuthority;
        _x.issuer = issuer;
        _x.issuerSki = issuerSki;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CertificateAuthority[");
        b.append("certificate=");
        b.append(this.certificate);
        b.append(", ");
        b.append("certificateRevocationListUrl=");
        b.append(this.certificateRevocationListUrl);
        b.append(", ");
        b.append("deltaCertificateRevocationListUrl=");
        b.append(this.deltaCertificateRevocationListUrl);
        b.append(", ");
        b.append("isRootAuthority=");
        b.append(this.isRootAuthority);
        b.append(", ");
        b.append("issuer=");
        b.append(this.issuer);
        b.append(", ");
        b.append("issuerSki=");
        b.append(this.issuerSki);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
