package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RoutingType;

@JsonPropertyOrder({
    "@odata.type", 
    "final", 
    "original", 
    "routingType"})
@JsonInclude(Include.NON_NULL)
public class CallRoute implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("final")
    protected IdentitySet final_;

    @JsonProperty("original")
    protected IdentitySet original;

    @JsonProperty("routingType")
    protected RoutingType routingType;

    protected CallRoute() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRoute";
    }

    @Property(name="final")
    @JsonIgnore
    public Optional<IdentitySet> getFinal() {
        return Optional.ofNullable(final_);
    }

    public CallRoute withFinal(IdentitySet final_) {
        CallRoute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRoute");
        _x.final_ = final_;
        return _x;
    }

    @Property(name="original")
    @JsonIgnore
    public Optional<IdentitySet> getOriginal() {
        return Optional.ofNullable(original);
    }

    public CallRoute withOriginal(IdentitySet original) {
        CallRoute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRoute");
        _x.original = original;
        return _x;
    }

    @Property(name="routingType")
    @JsonIgnore
    public Optional<RoutingType> getRoutingType() {
        return Optional.ofNullable(routingType);
    }

    public CallRoute withRoutingType(RoutingType routingType) {
        CallRoute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRoute");
        _x.routingType = routingType;
        return _x;
    }

    public CallRoute withUnmappedField(String name, Object value) {
        CallRoute _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet final_;
        private IdentitySet original;
        private RoutingType routingType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder final_(IdentitySet final_) {
            this.final_ = final_;
            this.changedFields = changedFields.add("final");
            return this;
        }

        public Builder original(IdentitySet original) {
            this.original = original;
            this.changedFields = changedFields.add("original");
            return this;
        }

        public Builder routingType(RoutingType routingType) {
            this.routingType = routingType;
            this.changedFields = changedFields.add("routingType");
            return this;
        }

        public CallRoute build() {
            CallRoute _x = new CallRoute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callRoute";
            _x.final_ = final_;
            _x.original = original;
            _x.routingType = routingType;
            return _x;
        }
    }

    private CallRoute _copy() {
        CallRoute _x = new CallRoute();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.final_ = final_;
        _x.original = original;
        _x.routingType = routingType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CallRoute[");
        b.append("final=");
        b.append(this.final_);
        b.append(", ");
        b.append("original=");
        b.append(this.original);
        b.append(", ");
        b.append("routingType=");
        b.append(this.routingType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
