package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.TeamworkCallEventType;

@JsonPropertyOrder({
    "@odata.type", 
    "callDuration", 
    "callEventType", 
    "callId", 
    "callParticipants", 
    "initiator"})
@JsonInclude(Include.NON_NULL)
public class CallEndedEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("callDuration")
    protected Duration callDuration;

    @JsonProperty("callEventType")
    protected TeamworkCallEventType callEventType;

    @JsonProperty("callId")
    protected String callId;

    @JsonProperty("callParticipants")
    protected List<CallParticipantInfo> callParticipants;

    @JsonProperty("callParticipants@nextLink")
    protected String callParticipantsNextLink;

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    protected CallEndedEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callEndedEventMessageDetail";
    }

    @Property(name="callDuration")
    @JsonIgnore
    public Optional<Duration> getCallDuration() {
        return Optional.ofNullable(callDuration);
    }

    public CallEndedEventMessageDetail withCallDuration(Duration callDuration) {
        CallEndedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callEndedEventMessageDetail");
        _x.callDuration = callDuration;
        return _x;
    }

    @Property(name="callEventType")
    @JsonIgnore
    public Optional<TeamworkCallEventType> getCallEventType() {
        return Optional.ofNullable(callEventType);
    }

    public CallEndedEventMessageDetail withCallEventType(TeamworkCallEventType callEventType) {
        CallEndedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callEndedEventMessageDetail");
        _x.callEventType = callEventType;
        return _x;
    }

    @Property(name="callId")
    @JsonIgnore
    public Optional<String> getCallId() {
        return Optional.ofNullable(callId);
    }

    public CallEndedEventMessageDetail withCallId(String callId) {
        CallEndedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callEndedEventMessageDetail");
        _x.callId = callId;
        return _x;
    }

    @Property(name="callParticipants")
    @JsonIgnore
    public CollectionPage<CallParticipantInfo> getCallParticipants() {
        return new CollectionPage<CallParticipantInfo>(contextPath, CallParticipantInfo.class, this.callParticipants, Optional.ofNullable(callParticipantsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="callParticipants")
    @JsonIgnore
    public CollectionPage<CallParticipantInfo> getCallParticipants(HttpRequestOptions options) {
        return new CollectionPage<CallParticipantInfo>(contextPath, CallParticipantInfo.class, this.callParticipants, Optional.ofNullable(callParticipantsNextLink), Collections.emptyList(), options);
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public CallEndedEventMessageDetail withInitiator(IdentitySet initiator) {
        CallEndedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callEndedEventMessageDetail");
        _x.initiator = initiator;
        return _x;
    }

    public CallEndedEventMessageDetail withUnmappedField(String name, Object value) {
        CallEndedEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCallEndedEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private Duration callDuration;
        private TeamworkCallEventType callEventType;
        private String callId;
        private List<CallParticipantInfo> callParticipants;
        private String callParticipantsNextLink;
        private IdentitySet initiator;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder callDuration(Duration callDuration) {
            this.callDuration = callDuration;
            this.changedFields = changedFields.add("callDuration");
            return this;
        }

        public Builder callEventType(TeamworkCallEventType callEventType) {
            this.callEventType = callEventType;
            this.changedFields = changedFields.add("callEventType");
            return this;
        }

        public Builder callId(String callId) {
            this.callId = callId;
            this.changedFields = changedFields.add("callId");
            return this;
        }

        public Builder callParticipants(List<CallParticipantInfo> callParticipants) {
            this.callParticipants = callParticipants;
            this.changedFields = changedFields.add("callParticipants");
            return this;
        }

        public Builder callParticipants(CallParticipantInfo... callParticipants) {
            return callParticipants(Arrays.asList(callParticipants));
        }

        public Builder callParticipantsNextLink(String callParticipantsNextLink) {
            this.callParticipantsNextLink = callParticipantsNextLink;
            this.changedFields = changedFields.add("callParticipants");
            return this;
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public CallEndedEventMessageDetail build() {
            CallEndedEventMessageDetail _x = new CallEndedEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callEndedEventMessageDetail";
            _x.callDuration = callDuration;
            _x.callEventType = callEventType;
            _x.callId = callId;
            _x.callParticipants = callParticipants;
            _x.callParticipantsNextLink = callParticipantsNextLink;
            _x.initiator = initiator;
            return _x;
        }
    }

    private CallEndedEventMessageDetail _copy() {
        CallEndedEventMessageDetail _x = new CallEndedEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.callDuration = callDuration;
        _x.callEventType = callEventType;
        _x.callId = callId;
        _x.callParticipants = callParticipants;
        _x.initiator = initiator;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CallEndedEventMessageDetail[");
        b.append("callDuration=");
        b.append(this.callDuration);
        b.append(", ");
        b.append("callEventType=");
        b.append(this.callEventType);
        b.append(", ");
        b.append("callId=");
        b.append(this.callId);
        b.append(", ");
        b.append("callParticipants=");
        b.append(this.callParticipants);
        b.append(", ");
        b.append("initiator=");
        b.append(this.initiator);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
