package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "durationInDays"})
@JsonInclude(Include.NON_NULL)
public class BusinessFlowSettings extends AccessReviewSettings implements ODataType {

    @JsonProperty("durationInDays")
    protected Integer durationInDays;

    protected BusinessFlowSettings() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.businessFlowSettings";
    }

    @Property(name="durationInDays")
    @JsonIgnore
    public Optional<Integer> getDurationInDays() {
        return Optional.ofNullable(durationInDays);
    }

    public BusinessFlowSettings withDurationInDays(Integer durationInDays) {
        BusinessFlowSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.businessFlowSettings");
        _x.durationInDays = durationInDays;
        return _x;
    }

    public BusinessFlowSettings withUnmappedField(String name, Object value) {
        BusinessFlowSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBusinessFlowSettings() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean accessRecommendationsEnabled;
        private Integer activityDurationInDays;
        private Boolean autoApplyReviewResultsEnabled;
        private Boolean autoReviewEnabled;
        private AutoReviewSettings autoReviewSettings;
        private Boolean justificationRequiredOnApproval;
        private Boolean mailNotificationsEnabled;
        private AccessReviewRecurrenceSettings recurrenceSettings;
        private Boolean remindersEnabled;
        private Integer durationInDays;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder accessRecommendationsEnabled(Boolean accessRecommendationsEnabled) {
            this.accessRecommendationsEnabled = accessRecommendationsEnabled;
            this.changedFields = changedFields.add("accessRecommendationsEnabled");
            return this;
        }

        public Builder activityDurationInDays(Integer activityDurationInDays) {
            this.activityDurationInDays = activityDurationInDays;
            this.changedFields = changedFields.add("activityDurationInDays");
            return this;
        }

        public Builder autoApplyReviewResultsEnabled(Boolean autoApplyReviewResultsEnabled) {
            this.autoApplyReviewResultsEnabled = autoApplyReviewResultsEnabled;
            this.changedFields = changedFields.add("autoApplyReviewResultsEnabled");
            return this;
        }

        public Builder autoReviewEnabled(Boolean autoReviewEnabled) {
            this.autoReviewEnabled = autoReviewEnabled;
            this.changedFields = changedFields.add("autoReviewEnabled");
            return this;
        }

        public Builder autoReviewSettings(AutoReviewSettings autoReviewSettings) {
            this.autoReviewSettings = autoReviewSettings;
            this.changedFields = changedFields.add("autoReviewSettings");
            return this;
        }

        public Builder justificationRequiredOnApproval(Boolean justificationRequiredOnApproval) {
            this.justificationRequiredOnApproval = justificationRequiredOnApproval;
            this.changedFields = changedFields.add("justificationRequiredOnApproval");
            return this;
        }

        public Builder mailNotificationsEnabled(Boolean mailNotificationsEnabled) {
            this.mailNotificationsEnabled = mailNotificationsEnabled;
            this.changedFields = changedFields.add("mailNotificationsEnabled");
            return this;
        }

        public Builder recurrenceSettings(AccessReviewRecurrenceSettings recurrenceSettings) {
            this.recurrenceSettings = recurrenceSettings;
            this.changedFields = changedFields.add("recurrenceSettings");
            return this;
        }

        public Builder remindersEnabled(Boolean remindersEnabled) {
            this.remindersEnabled = remindersEnabled;
            this.changedFields = changedFields.add("remindersEnabled");
            return this;
        }

        public Builder durationInDays(Integer durationInDays) {
            this.durationInDays = durationInDays;
            this.changedFields = changedFields.add("durationInDays");
            return this;
        }

        public BusinessFlowSettings build() {
            BusinessFlowSettings _x = new BusinessFlowSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.businessFlowSettings";
            _x.accessRecommendationsEnabled = accessRecommendationsEnabled;
            _x.activityDurationInDays = activityDurationInDays;
            _x.autoApplyReviewResultsEnabled = autoApplyReviewResultsEnabled;
            _x.autoReviewEnabled = autoReviewEnabled;
            _x.autoReviewSettings = autoReviewSettings;
            _x.justificationRequiredOnApproval = justificationRequiredOnApproval;
            _x.mailNotificationsEnabled = mailNotificationsEnabled;
            _x.recurrenceSettings = recurrenceSettings;
            _x.remindersEnabled = remindersEnabled;
            _x.durationInDays = durationInDays;
            return _x;
        }
    }

    private BusinessFlowSettings _copy() {
        BusinessFlowSettings _x = new BusinessFlowSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.accessRecommendationsEnabled = accessRecommendationsEnabled;
        _x.activityDurationInDays = activityDurationInDays;
        _x.autoApplyReviewResultsEnabled = autoApplyReviewResultsEnabled;
        _x.autoReviewEnabled = autoReviewEnabled;
        _x.autoReviewSettings = autoReviewSettings;
        _x.justificationRequiredOnApproval = justificationRequiredOnApproval;
        _x.mailNotificationsEnabled = mailNotificationsEnabled;
        _x.recurrenceSettings = recurrenceSettings;
        _x.remindersEnabled = remindersEnabled;
        _x.durationInDays = durationInDays;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BusinessFlowSettings[");
        b.append("accessRecommendationsEnabled=");
        b.append(this.accessRecommendationsEnabled);
        b.append(", ");
        b.append("activityDurationInDays=");
        b.append(this.activityDurationInDays);
        b.append(", ");
        b.append("autoApplyReviewResultsEnabled=");
        b.append(this.autoApplyReviewResultsEnabled);
        b.append(", ");
        b.append("autoReviewEnabled=");
        b.append(this.autoReviewEnabled);
        b.append(", ");
        b.append("autoReviewSettings=");
        b.append(this.autoReviewSettings);
        b.append(", ");
        b.append("justificationRequiredOnApproval=");
        b.append(this.justificationRequiredOnApproval);
        b.append(", ");
        b.append("mailNotificationsEnabled=");
        b.append(this.mailNotificationsEnabled);
        b.append(", ");
        b.append("recurrenceSettings=");
        b.append(this.recurrenceSettings);
        b.append(", ");
        b.append("remindersEnabled=");
        b.append(this.remindersEnabled);
        b.append(", ");
        b.append("durationInDays=");
        b.append(this.durationInDays);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
